/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public final class RocksDBConfigSetterHandler {
    private RocksDBConfigSetterHandler() {
    }

    public static void maybeConfigureRocksDBConfigSetter(KsqlConfig ksqlConfig) {
        Map streamsProps = ksqlConfig.getKsqlStreamConfigProps();
        Class clazz = (Class)streamsProps.get("rocksdb.config.setter");
        if (clazz != null && Configurable.class.isAssignableFrom(clazz)) {
            try {
                ((Configurable)Utils.newInstance((Class)clazz)).configure(ksqlConfig.originals());
            }
            catch (Exception e) {
                throw new ConfigException("Failed to configure Configurable RocksDBConfigSetter. rocksdb.config.setter: " + clazz.getName(), (Object)e);
            }
        }
    }
}

