/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.util.ColumnExtractor;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ScalablePushUtil {
    private static String LATEST_VALUE = "latest";

    private ScalablePushUtil() {
    }

    public static boolean isScalablePushQuery(Statement statement, KsqlExecutionContext ksqlEngine, KsqlConfig ksqlConfig, Map<String, Object> overrides) {
        if (!ScalablePushUtil.isPushV2Enabled(ksqlConfig, overrides)) {
            return false;
        }
        if (!(statement instanceof Query)) {
            return false;
        }
        Query query = (Query)statement;
        SourceFinder sourceFinder = new SourceFinder();
        sourceFinder.process((AstNode)query.getFrom(), null);
        if (!sourceFinder.getSourceName().isPresent()) {
            return false;
        }
        SourceName sourceName = sourceFinder.getSourceName().get();
        Set upstreamQueries = ksqlEngine.getQueriesWithSink(sourceName);
        boolean isLatest = ScalablePushUtil.isLatest(ksqlConfig, overrides);
        return !query.isPullQuery() && !query.getGroupBy().isPresent() && !query.getWindow().isPresent() && !query.getHaving().isPresent() && !query.getPartitionBy().isPresent() && query.getRefinement().isPresent() && ((RefinementInfo)query.getRefinement().get()).getOutputRefinement() == OutputRefinement.CHANGES && isLatest && upstreamQueries.size() == 1 && !ScalablePushUtil.containsDisallowedColumns(query);
    }

    private static boolean containsDisallowedColumns(Query query) {
        return ScalablePushUtil.containsDisallowedColumnsInWhereClause(query) || ScalablePushUtil.containsDisallowedColumnsInSelectClause(query);
    }

    private static boolean containsDisallowedColumnsInWhereClause(Query query) {
        Optional whereClause = query.getWhere();
        if (!whereClause.isPresent()) {
            return false;
        }
        return ColumnExtractor.extractColumns((Expression)((Expression)whereClause.get())).stream().map(ColumnReferenceExp::getColumnName).anyMatch(SystemColumns::isDisallowedInPullOrScalablePushQueries);
    }

    private static boolean containsDisallowedColumnsInSelectClause(Query query) {
        return query.getSelect().getSelectItems().stream().filter(col -> col instanceof SingleColumn).map(SingleColumn.class::cast).map(SingleColumn::getExpression).map(ColumnExtractor::extractColumns).flatMap(Collection::stream).map(ColumnReferenceExp::getColumnName).anyMatch(SystemColumns::isDisallowedInPullOrScalablePushQueries);
    }

    private static boolean isPushV2Enabled(KsqlConfig ksqlConfig, Map<String, Object> overrides) {
        if (overrides.containsKey("ksql.query.push.v2.enabled")) {
            return Boolean.TRUE.equals(overrides.get("ksql.query.push.v2.enabled"));
        }
        return ksqlConfig.getBoolean("ksql.query.push.v2.enabled");
    }

    private static boolean isLatest(KsqlConfig ksqlConfig, Map<String, Object> overrides) {
        if (overrides.containsKey("auto.offset.reset")) {
            return LATEST_VALUE.equals(overrides.get("auto.offset.reset"));
        }
        if (overrides.containsKey("ksql.streams.auto.offset.reset")) {
            return LATEST_VALUE.equals(overrides.get("ksql.streams.auto.offset.reset"));
        }
        if (ksqlConfig.getKsqlStreamConfigProp("auto.offset.reset").isPresent()) {
            return LATEST_VALUE.equals(ksqlConfig.getKsqlStreamConfigProp("auto.offset.reset").orElse(null));
        }
        return true;
    }

    private static final class SourceFinder
    extends AstVisitor<Void, Void> {
        private SourceName sourceName;

        private SourceFinder() {
        }

        protected Void visitAliasedRelation(AliasedRelation node, Void context) {
            this.process((AstNode)node.getRelation(), context);
            return null;
        }

        protected Void visitTable(Table node, Void context) {
            this.sourceName = node.getName();
            return null;
        }

        public Optional<SourceName> getSourceName() {
            return Optional.ofNullable(this.sourceName);
        }
    }
}

