/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.CallingResourceIdentityType;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.server.util.Csv;

public class CallingResourceIdentityTypeExtractor
implements Configurable {
    private Map<Pattern, CallingResourceIdentityType> callingResourceIdentityMap;

    public CallingResourceIdentityType extractType(String callingResourceIdentity) {
        if (callingResourceIdentity == null) {
            return CallingResourceIdentityType.DEFAULT;
        }
        for (Map.Entry<Pattern, CallingResourceIdentityType> entry : this.callingResourceIdentityMap.entrySet()) {
            if (!entry.getKey().matcher(callingResourceIdentity).lookingAt()) continue;
            return entry.getValue();
        }
        return CallingResourceIdentityType.DEFAULT;
    }

    public void configure(Map<String, ?> configs) {
        this.callingResourceIdentityMap = CallingResourceIdentityTypeExtractor.parseConfig(configs);
    }

    private static Map<Pattern, CallingResourceIdentityType> parseConfig(Map<String, ?> configs) {
        HashMap<Pattern, CallingResourceIdentityType> parseResult;
        Map rawMap;
        try {
            rawMap = Csv.parseCsvMap((String)((String)configs.get("confluent.calling.resource.identity.type.map")));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error parsing configuration property '%s'", "confluent.calling.resource.identity.type.map"), e);
        }
        try {
            parseResult = new HashMap<Pattern, CallingResourceIdentityType>();
            for (Map.Entry entry : rawMap.entrySet()) {
                parseResult.put(Pattern.compile((String)entry.getKey()), CallingResourceIdentityType.valueOf((String)((String)entry.getValue())));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Undefined calling resource identity found in the configuration property '%s'", "confluent.calling.resource.identity.type.map"), e);
        }
        return parseResult;
    }
}

