/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.cloud.protobuf.traffic.networkcontext.v1.ConnectionContext;
import io.confluent.cloud.protobuf.traffic.networkcontext.v1.NetworkContext;
import io.confluent.kafka.common.network.CloudProxyTlvParser;
import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.metrics.HotPartitionManager;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvProvider;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkInfoStore;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;

public class MultiTenantInterceptor
implements BrokerInterceptor {
    private final Time time;
    private final TenantMetrics tenantMetrics;
    private final HotPartitionManager hotPartitionManager;
    private Optional<ClusterLinkSourceMetrics> clusterLinkSourceMetrics;
    private MultiTenantInterceptorConfig multiTenantInterceptorConfig;
    private boolean clusterLinkMetricReductionAdvancedEnabled;
    private boolean recordApiVersionsRequests;
    private int clientIdsPerTenantCap;
    private ClusterLinkInfoStore clusterLinkInfoStore;
    private String defaultNetworkType;

    public MultiTenantInterceptor() {
        this(Time.SYSTEM);
    }

    public MultiTenantInterceptor(Time time) {
        this.time = time;
        this.tenantMetrics = new TenantMetrics();
        this.hotPartitionManager = new HotPartitionManager(time);
        this.clusterLinkSourceMetrics = Optional.empty();
    }

    public void onAuthenticatedConnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics, ChannelMetadataRegistry metadataRegistry) {
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal tenantPrincipal = (MultiTenantPrincipal)principal;
            this.tenantMetrics.recordAuthenticatedConnection(metrics, tenantPrincipal, clientAddress);
            if (this.recordApiVersionsRequests) {
                boolean allInformationAvailable;
                ClientInformation clientInformation = metadataRegistry.clientInformation();
                String clientId = metadataRegistry.clientId();
                boolean bl = allInformationAvailable = !ClientInformation.isNullOrEmpty((ClientInformation)clientInformation) && clientId != null && !clientId.isEmpty();
                if (allInformationAvailable) {
                    this.tenantMetrics.recordClientInformation(metrics, tenantPrincipal, clientInformation, clientId, this.clientIdsPerTenantCap);
                }
            }
        } else {
            throw new IllegalStateException("Not a tenant connection");
        }
    }

    public void onAuthenticatedDisconnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
        this.tenantMetrics.recordAuthenticatedDisconnection();
    }

    public void onFailedAuthentication(String connectionId, InetAddress clientAddress, Metrics metrics) {
        this.tenantMetrics.recordFailedAuthentication(metrics, clientAddress);
    }

    public void onApiVersionsRequest(ClientInformation clientInformation, String clientId, KafkaPrincipal principal, Metrics metrics) {
        if (principal instanceof MultiTenantPrincipal) {
            if (this.recordApiVersionsRequests) {
                this.tenantMetrics.recordClientInformation(metrics, (MultiTenantPrincipal)principal, clientInformation, clientId, this.clientIdsPerTenantCap);
            }
        } else {
            throw new IllegalStateException("Not a tenant connection");
        }
    }

    public void configure(Map<String, ?> configs) {
        this.multiTenantInterceptorConfig = MultiTenantInterceptorConfig.fromConfigMap(configs);
        this.clusterLinkMetricReductionAdvancedEnabled = ConfluentConfigs.clusterLinkMetricReductionAdvancedEnabled(configs);
        this.recordApiVersionsRequests = ConfluentConfigs.multiTenantInterceptorCollectApiVersionsEnabled(configs);
        this.clientIdsPerTenantCap = ConfluentConfigs.multiTenantInterceptorCollectApiVersionsMaxPerTenant(configs);
        this.hotPartitionManager.configure(configs);
        this.tenantMetrics.configure(configs);
        this.clusterLinkInfoStore = ClusterLinkInfoStore.getInstance((String)AuthUtils.getBrokerSessionUuid(configs));
        String defaultNetworkTypeConfig = (String)configs.get("confluent.emit.network.type.default");
        this.defaultNetworkType = Objects.requireNonNullElse(defaultNetworkTypeConfig, "");
    }

    String networkType(ProxyTlvProvider provider) {
        ProxyTlv tlv = provider.tlv(CloudProxyTlvParser.NETWORK_CONTEXT_TLV_TYPE);
        if (tlv == null) {
            return this.defaultNetworkType;
        }
        NetworkContext networkContext = (NetworkContext)tlv.computedValue();
        if (networkContext == null) {
            return this.defaultNetworkType;
        }
        ConnectionContext.ConnectionTypeCase typeCase = networkContext.getConnectionContext().getConnectionTypeCase();
        if (typeCase == ConnectionContext.ConnectionTypeCase.CONNECTIONTYPE_NOT_SET) {
            return this.defaultNetworkType;
        }
        return typeCase.name().toLowerCase(Locale.ROOT).replaceAll("_", "-");
    }

    public RequestContext newContext(BrokerInterceptor.RequestContextOptions options) {
        if (!(options.principal() instanceof MultiTenantPrincipal)) {
            throw new IllegalArgumentException("Unexpected principal type " + String.valueOf(options.principal()));
        }
        MultiTenantPrincipal tenantPrincipal = (MultiTenantPrincipal)options.principal();
        options.header().clusterLinkId().ifPresent(linkId -> {
            this.clusterLinkSourceMetrics.ifPresent(linkMetrics -> linkMetrics.ensureLinkId(linkId));
            if (this.clusterLinkSourceMetrics.isEmpty()) {
                HashMap<String, String> tenantTags = new HashMap<String, String>();
                tenantTags.put("tenant", tenantPrincipal.tenantMetadata().tenantName);
                String sensorSuffix = String.format(":%s-%s", "tenant", tenantPrincipal.tenantMetadata().tenantName);
                boolean skipSourceLinkCountSensor = this.clusterLinkInfoStore.hasDestinationLink(linkId);
                this.clusterLinkSourceMetrics = Optional.of(new ClusterLinkSourceMetrics(options.metrics(), linkId, tenantTags, sensorSuffix, this.clusterLinkMetricReductionAdvancedEnabled, skipSourceLinkCountSensor));
            }
        });
        String networkType = null;
        if (options.proxyTlvProvider().isPresent()) {
            networkType = this.networkType((ProxyTlvProvider)options.proxyTlvProvider().get());
        }
        return new MultiTenantRequestContext(options.header(), options.connectionId(), options.requestId(), options.clientAddress(), options.clientPort(), tenantPrincipal, options.listenerName(), options.securityProtocol(), options.clientInformation(), options.sniHostName(), this.time, options.metrics(), this.tenantMetrics, this.hotPartitionManager, this.multiTenantInterceptorConfig, this.clusterLinkSourceMetrics, options.isPrivilegedListener(), options.principalSerde(), options.authenticationContext(), options.produceConsumeAuditLogTracker(), options.isProxyModeLocal(), options.fqdnPropertiesFromPpv2(), networkType, options.shouldLogForConnection(), options.confluentMetricsContextProvider());
    }
}

