/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.authorizer;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.audit.DefaultTenantSanitizer;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuditLogConfig;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.GroupProvider;
import io.confluent.security.authorizer.provider.MetadataProvider;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class MultiTenantAuthorizer
extends ConfluentServerAuthorizer {
    public static final String MAX_ACLS_PER_TENANT_PROP = "confluent.max.acls.per.tenant";
    private static final int ACLS_DISABLED = 0;
    public static final String RESOURCE_ID = "resource-id";
    public static final String INTEGER_ID = "integer-id";
    private boolean authorizationDisabled;
    private boolean auditLogEnabled;
    private boolean oauthSuperUserDisable;
    private boolean enableDataplaneRbacForPKC;
    private TenantAuthorizerMetrics mtAuthorizerMetrics;
    private boolean supportUserResourceId;
    private DefaultUserMetaDataStore userMetaDataStore;
    private Map<String, ?> configs;
    private final AuthorizerConfig config = new AuthorizerConfig();

    @VisibleForTesting
    public void configureAccessRuleProviders(Map<String, Object> configs) {
        Object accessRuleProviders = configs.get("confluent.authorizer.access.rule.providers");
        if (!(accessRuleProviders instanceof String) || Arrays.stream(((String)accessRuleProviders).split(",")).noneMatch(provider -> ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name().equals(provider))) {
            configs.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name());
        }
    }

    @Override
    public void configureServerInfo(ConfluentAuthorizerServerInfo serverInfo) {
        this.mtAuthorizerMetrics = new TenantAuthorizerMetrics(serverInfo.metrics());
        this.config.setMetrics(this.metrics());
        super.configureServerInfo(serverInfo);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = configs;
        HashMap<String, Object> authorizerConfigs = new HashMap<String, Object>(configs);
        String maxAcls = (String)configs.get(MAX_ACLS_PER_TENANT_PROP);
        this.config.setDefaultMaxAcls(maxAcls == null ? null : Integer.valueOf(Integer.parseInt(maxAcls)));
        this.authorizationDisabled = this.config.defaultMaxAcls() == 0;
        this.configureAccessRuleProviders(authorizerConfigs);
        MultiTenantAuditLogConfig multiTenantAuditLogConfig = new MultiTenantAuditLogConfig(configs);
        this.auditLogEnabled = multiTenantAuditLogConfig.getBoolean("confluent.security.event.logger.multitenant.enable");
        this.oauthSuperUserDisable = true;
        if (configs.containsKey("multitenant.oauth.superuser.disable")) {
            this.oauthSuperUserDisable = Boolean.parseBoolean((String)configs.get("multitenant.oauth.superuser.disable"));
        }
        this.enableDataplaneRbacForPKC = false;
        if (configs.containsKey("confluent.metadata.kafka.enable.dataplane.rbac")) {
            this.enableDataplaneRbacForPKC = Boolean.parseBoolean((String)configs.get("confluent.metadata.kafka.enable.dataplane.rbac"));
        }
        this.supportUserResourceId = false;
        if (configs.containsKey("multitenant.authorizer.support.resource.ids")) {
            this.supportUserResourceId = Boolean.parseBoolean((String)configs.get("multitenant.authorizer.support.resource.ids"));
        }
        super.configure(authorizerConfigs);
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        Set<String> result = super.reconfigurableConfigs();
        result.add("multitenant.authorizer.support.resource.ids");
        return result;
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        if (configs.containsKey("multitenant.authorizer.support.resource.ids")) {
            this.supportUserResourceId = (Boolean)configs.get("multitenant.authorizer.support.resource.ids");
        }
        super.reconfigure(configs);
    }

    @Override
    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        List<AuthorizationResult> results = super.authorize(requestContext, actions);
        if (this.mtAuthorizerMetrics != null) {
            this.mtAuthorizerMetrics.recordAuthorizationDeniedMetric(requestContext, results, actions);
        }
        return results;
    }

    protected boolean isSuperUser(KafkaPrincipal sessionPrincipal, KafkaPrincipal userOrGroupPrincipal, io.confluent.security.authorizer.Action action) {
        if (super.isSuperUser(sessionPrincipal, userOrGroupPrincipal, action)) {
            return true;
        }
        if (sessionPrincipal instanceof MultiTenantPrincipal) {
            return MultiTenantAuthorizer.isSuperUser((MultiTenantPrincipal)sessionPrincipal, action, this.authorizationDisabled, this.enableDataplaneRbacForPKC, this.oauthSuperUserDisable);
        }
        return false;
    }

    public static boolean isSuperUser(MultiTenantPrincipal tenantPrincipal, io.confluent.security.authorizer.Action action, boolean authorizationDisabled, boolean enableDataplaneRbacForPKC, boolean oauthSuperUserDisable) {
        return (authorizationDisabled || tenantPrincipal.isSuperUser(enableDataplaneRbacForPKC, oauthSuperUserDisable)) && action.resourceName().startsWith(tenantPrincipal.tenantMetadata().tenantPrefix());
    }

    protected io.confluent.security.authorizer.Action actionForAuthorizeByResourceType(RequestContext requestContext, Operation operation, ResourceType resourceType) {
        if (requestContext.principal() instanceof MultiTenantPrincipal) {
            return new io.confluent.security.authorizer.Action(((MultiTenantPrincipal)requestContext.principal()).tenantMetadata().scope(), new io.confluent.security.authorizer.ResourcePattern(resourceType, "", PatternType.ANY), operation, 1, true, true);
        }
        return super.actionForAuthorizeByResourceType(requestContext, operation, resourceType);
    }

    @Override
    public io.confluent.security.authorizer.Action buildAction(Action kafkaAction, ResourcePattern resourcePattern, KafkaPrincipal sessionPrincipal, Scope scope) {
        Scope actionScope = scope;
        ResourcePattern pattern = resourcePattern;
        if (sessionPrincipal instanceof MultiTenantPrincipal) {
            TenantMetadata tenantMetadata = ((MultiTenantPrincipal)sessionPrincipal).tenantMetadata();
            actionScope = tenantMetadata.scope();
            ResourcePattern resource = kafkaAction.resourcePattern();
            if (resource.resourceType() == org.apache.kafka.common.resource.ResourceType.CLUSTER) {
                pattern = new ResourcePattern(org.apache.kafka.common.resource.ResourceType.CLUSTER, tenantMetadata.tenantPrefix() + resource.name(), resource.patternType());
            }
        }
        return super.buildAction(kafkaAction, pattern, sessionPrincipal, actionScope);
    }

    @Override
    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return this.createAclsInternal(requestContext, aclBindings);
    }

    @Override
    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, Optional<String> clusterId) {
        return this.createAclsInternal(requestContext, aclBindings);
    }

    private List<? extends CompletionStage<AclCreateResult>> createAclsInternal(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        this.checkAclsEnabled();
        if (aclBindings.isEmpty()) {
            return Collections.emptyList();
        }
        String firstPrincipal = aclBindings.get(0).entry().principal();
        String firstPrincipalTenantPrefix = this.multiTenantPrincipalTenantPrefix(firstPrincipal, requestContext);
        this.validateAclBindingsCreateAclsRequest(aclBindings, firstPrincipalTenantPrefix);
        this.recordCreateAclMetric(firstPrincipal);
        if (this.supportUserResourceId) {
            return this.createAclsInternalWithResourceId(requestContext, aclBindings);
        }
        return super.createAcls(requestContext, aclBindings);
    }

    private List<? extends CompletionStage<AclCreateResult>> createAclsInternalWithResourceId(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        String firstPrincipal = aclBindings.get(0).entry().principal();
        Set<AclBinding> existingAcls = this.tenantAclBinding(this.multiTenantPrincipalTenantPrefix(firstPrincipal, requestContext));
        ArrayList<AclBinding> newAclBindings = new ArrayList<AclBinding>();
        Iterator<AclBinding> iterator = aclBindings.iterator();
        while (iterator.hasNext()) {
            AclBinding aclBinding;
            boolean isResourceId = this.principalIdType((aclBinding = iterator.next()).entry().principal()).equals(RESOURCE_ID);
            AclBinding convertedAclBinding = this.convertAclBinding(aclBinding, !isResourceId);
            if (!isResourceId && existingAcls.contains(convertedAclBinding)) {
                newAclBindings.add(convertedAclBinding);
                continue;
            }
            newAclBindings.add(aclBinding);
        }
        List<? extends CompletionStage<AclCreateResult>> aclCreateResults = super.createAcls(requestContext, newAclBindings);
        this.deleteIntegerIdBasedAcls(requestContext, newAclBindings, aclCreateResults, existingAcls);
        return aclCreateResults;
    }

    private void deleteIntegerIdBasedAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, List<? extends CompletionStage<AclCreateResult>> aclCreateResults, Set<AclBinding> existingAcls) {
        ArrayList<AclBindingFilter> aclBindingFilters = new ArrayList<AclBindingFilter>();
        for (int i = 0; i < aclBindings.size(); ++i) {
            Boolean isResourceId;
            AclBinding convertedAclBinding = this.convertAclBinding(aclBindings.get(i), (isResourceId = Boolean.valueOf(this.principalIdType(aclBindings.get(i).entry().principal()).equals(RESOURCE_ID))) == false);
            try {
                if (!isResourceId.booleanValue() || aclCreateResults.get(i).toCompletableFuture().get().exception().isPresent() || convertedAclBinding.equals((Object)aclBindings.get(i)) || !existingAcls.contains(convertedAclBinding)) continue;
                aclBindingFilters.add(convertedAclBinding.toFilter());
                continue;
            }
            catch (Exception e) {
                log.warn("Got an exception while creating the AclBinding: {}, exception {}", (Object)aclBindings.get(i), (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (!aclBindingFilters.isEmpty()) {
            List<? extends CompletionStage<AclDeleteResult>> aclDeleteResults = super.deleteAcls(requestContext, aclBindingFilters, Optional.empty(), AclState.ANY);
            for (int i = 0; i < aclBindingFilters.size(); ++i) {
                AclBindingFilter aclBindingFilter = (AclBindingFilter)aclBindingFilters.get(i);
                try {
                    if (!aclDeleteResults.get(i).toCompletableFuture().get().exception().isPresent()) continue;
                    log.warn("Delete ACls failed while deleting integerId based ACLs for filter: {}, exception: {}", (Object)aclBindingFilter, aclDeleteResults.get(i).toCompletableFuture().get().exception().get());
                    continue;
                }
                catch (Exception e) {
                    log.warn("Got an exception while deleting integerId based ACLs for filter: {}, exception: {}", (Object)aclBindingFilter, (Object)e);
                }
            }
        }
    }

    private void validateAclBindingsCreateAclsRequest(List<AclBinding> aclBindings, String firstPrincipalTenantPrefix) {
        if (aclBindings.stream().anyMatch(acl -> !this.inScope(acl.entry().principal(), firstPrincipalTenantPrefix))) {
            log.error("ACL requests contain invalid tenant principal {}", aclBindings);
            throw new InvalidRequestException("Internal error: Could not create ACLs because all principals are not in the same scope " + String.valueOf(aclBindings));
        }
        if (firstPrincipalTenantPrefix != null) {
            if (aclBindings.stream().anyMatch(acl -> !acl.pattern().name().startsWith(firstPrincipalTenantPrefix))) {
                log.error("Unexpected ACL request for resources {} without tenant prefix {}", aclBindings, (Object)firstPrincipalTenantPrefix);
                throw new InvalidRequestException("Internal error: Could not create ACLs because tenant prefixes are not the same " + String.valueOf(aclBindings));
            }
            int maxAclsPerTenant = this.config.maxAcls(firstPrincipalTenantPrefix.substring(0, firstPrincipalTenantPrefix.length() - 1));
            if (this.exceedsAclLimit(firstPrincipalTenantPrefix, aclBindings, maxAclsPerTenant)) {
                throw new InvalidRequestException("ACLs not created since it will exceed the limit " + maxAclsPerTenant);
            }
            List<AclBinding> invalidAcls = aclBindings.stream().filter(acl -> !this.validResourceName((AclBinding)acl)).collect(Collectors.toList());
            if (!invalidAcls.isEmpty()) {
                String invalidResourceNames = this.resourceNames(invalidAcls, firstPrincipalTenantPrefix);
                log.warn("Invalid Resource name for given Resource type and Pattern Type : {}", (Object)invalidResourceNames);
                throw new InvalidRequestException("Internal error: Could not create ACLs because following resource names are invalid : " + invalidResourceNames);
            }
        }
    }

    private boolean validResourceName(AclBinding acl) {
        if (acl.pattern().resourceType() == org.apache.kafka.common.resource.ResourceType.TOPIC) {
            return Topic.isValid((String)acl.pattern().name());
        }
        return true;
    }

    private String resourceNames(List<AclBinding> acls, String prefix) {
        return acls.stream().map(aclBinding -> aclBinding.pattern().name().substring(prefix.length())).collect(Collectors.toList()).toString();
    }

    private String multiTenantPrincipalTenantPrefix(String principal, AuthorizableRequestContext requestContext) {
        KafkaPrincipal kafkaPrincipal = SecurityUtils.parseKafkaPrincipal((String)principal);
        boolean isMultiTenant = MultiTenantPrincipal.isTenantPrincipal((KafkaPrincipal)kafkaPrincipal) || requestContext.principal() instanceof MultiTenantPrincipal;
        return isMultiTenant ? this.tenantPrefix(kafkaPrincipal.getName()) : null;
    }

    @Override
    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> clusterId, AclState aclState) {
        if (aclBindingFilters.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkAclsEnabled();
        if (this.supportUserResourceId) {
            this.recordDeleteAclMetric(aclBindingFilters.get(0).entryFilter().principal());
            return this.deleteAclsWithResourceIdSupport(requestContext, aclBindingFilters, clusterId, aclState);
        }
        List<AclBindingFilter> convertedAclBindingFilter = aclBindingFilters.stream().map(this::convertUserV2Filter).collect(Collectors.toList());
        return super.deleteAcls(requestContext, convertedAclBindingFilter, clusterId, aclState);
    }

    private List<? extends CompletionStage<AclDeleteResult>> deleteAclsWithResourceIdSupport(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> clusterId, AclState aclState) {
        List<? extends CompletionStage<AclDeleteResult>> results = super.deleteAcls(requestContext, aclBindingFilters, clusterId, aclState);
        List<? extends CompletionStage<AclDeleteResult>> resultsOfConvertedFilters = super.deleteAcls(requestContext, this.convertAclFilters(aclBindingFilters), clusterId, aclState);
        return this.combineAclDeleteResults(aclBindingFilters, results, resultsOfConvertedFilters);
    }

    protected List<? extends CompletionStage<AclDeleteResult>> combineAclDeleteResults(List<AclBindingFilter> aclBindingFilters, List<? extends CompletionStage<AclDeleteResult>> results, List<? extends CompletionStage<AclDeleteResult>> resultsOfConvertedFilters) {
        ArrayList<CompletionStage<AclDeleteResult>> finalResults = new ArrayList<CompletionStage<AclDeleteResult>>();
        for (int i = 0; i < results.size(); ++i) {
            boolean toUserResource = this.convertToUserResource(aclBindingFilters.get(i));
            finalResults.add(results.get(i).thenCombine(resultsOfConvertedFilters.get(i), (aclDeleteResult1, aclDeleteResult2) -> {
                if (aclDeleteResult1.exception().isPresent()) {
                    return aclDeleteResult1;
                }
                if (aclDeleteResult2.exception().isPresent()) {
                    return aclDeleteResult2;
                }
                return new AclDeleteResult(this.convertAclBindingDeleteResults(Stream.concat(aclDeleteResult1.aclBindingDeleteResults().stream(), aclDeleteResult2.aclBindingDeleteResults().stream()).collect(Collectors.toList()), toUserResource));
            }));
        }
        return finalResults;
    }

    @Override
    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        return this.deleteAcls(requestContext, aclBindingFilters, Optional.empty(), AclState.ANY);
    }

    @Override
    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        return this.acls(filter, AclState.ACTIVE);
    }

    @Override
    public Iterable<AclBinding> acls(AclBindingFilter filter, AclState aclState) {
        this.checkAclsEnabled();
        if (this.supportUserResourceId) {
            this.recordDescribeAclMetric(filter.entryFilter().principal());
            return this.describeAclsWithResourceIdSupport(filter, aclState);
        }
        return super.acls(this.convertUserV2Filter(filter), aclState);
    }

    protected void configureProviders(List<AccessRuleProvider> accessRuleProviders, GroupProvider groupProvider, MetadataProvider metadataProvider, AuditLogProvider auditLogProvider) {
        if (this.auditLogEnabled) {
            DefaultTenantSanitizer defaultTenantSanitizer = new DefaultTenantSanitizer();
            defaultTenantSanitizer.configure(this.configs);
            auditLogProvider.setSanitizer(defaultTenantSanitizer::tenantAuditEvent);
            super.configureProviders(accessRuleProviders, groupProvider, metadataProvider, auditLogProvider);
        } else {
            super.configureProviders(accessRuleProviders, groupProvider, metadataProvider, null);
        }
    }

    public Optional<AuthorizerConfig> config() {
        return Optional.of(this.config);
    }

    @Override
    public void loadAclSnapshot(Map<Uuid, ConfluentStandardAcl> acls) {
        super.loadAclSnapshot(acls);
        this.updateTenantAclCountMap();
    }

    @Override
    public void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
        super.applyAclChanges(aclChanges);
        this.updateTenantAclCountMap();
    }

    private void updateTenantAclCountMap() {
        if (this.authorizationDisabled) {
            return;
        }
        Iterable<AclBinding> bindings = this.acls(AclBindingFilter.ANY);
        Map<String, Integer> newTenantAclCountMap = StreamSupport.stream(bindings.spliterator(), false).filter(binding -> this.getTenantIdFromPrincipalString(binding.entry().principal()) != null).collect(Collectors.groupingBy(binding -> this.getTenantIdFromPrincipalString(binding.entry().principal()), Collectors.summingInt(binding -> 1)));
        this.config.loadNewTenantIdToAclCount(newTenantAclCountMap);
    }

    String getTenantIdFromPrincipalString(String principal) {
        if (principal == null) {
            return null;
        }
        KafkaPrincipal kafkaPrincipal = SecurityUtils.parseKafkaPrincipal((String)principal);
        if (!MultiTenantPrincipal.isTenantPrincipal((KafkaPrincipal)kafkaPrincipal)) {
            return null;
        }
        return this.getTenantId(kafkaPrincipal.getName());
    }

    private String getTenantId(String principal) {
        String tenantPrefix = this.tenantPrefix(principal);
        String tenantId = tenantPrefix.substring(0, tenantPrefix.length() - 1);
        return tenantId;
    }

    protected void incrementTenantAclCount(String tenantId) {
        this.config.incrementTenantAclCount(tenantId);
        this.config.addAclCountMetric(tenantId);
    }

    protected void decrementTenantAclCount(String tenantId) {
        this.config.decrementTenantAclCount(tenantId);
        this.config.addAclCountMetric(tenantId);
    }

    private AclBindingFilter convertUserV2Filter(AclBindingFilter filter) {
        boolean isV2Principal;
        boolean bl = isV2Principal = filter.entryFilter().principal() != null && SecurityUtils.parseKafkaPrincipal((String)filter.entryFilter().principal()).getPrincipalType().equals("TenantUserV2*");
        if (isV2Principal) {
            AccessControlEntryFilter wildcardPrincipalFilter = new AccessControlEntryFilter(null, filter.entryFilter().host(), filter.entryFilter().operation(), filter.entryFilter().permissionType(), filter.entryFilter().clusterLinkIds());
            return new AclBindingFilter(filter.patternFilter(), wildcardPrincipalFilter);
        }
        return filter;
    }

    private void initializeUserMetaDataStore() {
        if (this.userMetaDataStore == null) {
            this.userMetaDataStore = DefaultUserMetaDataStore.getInstance(AuthUtils.getBrokerSessionUuid(this.configs));
        }
    }

    protected void updateUserMetaDataStore(DefaultUserMetaDataStore userMetaDataStore) {
        this.userMetaDataStore = userMetaDataStore;
    }

    private boolean convertToUserResource(AclBindingFilter aclBindingFilter) {
        if (this.anyPrincipalWithOldFormat(aclBindingFilter.entryFilter())) {
            return false;
        }
        if (SecurityUtils.parseKafkaPrincipal((String)aclBindingFilter.entryFilter().principal()).getPrincipalType().equals("TenantUserV2*")) {
            return true;
        }
        return !this.unPrefixedPrincipal(SecurityUtils.parseKafkaPrincipal((String)aclBindingFilter.entryFilter().principal()).getName()).matches("[0-9]+");
    }

    private Collection<AclDeleteResult.AclBindingDeleteResult> convertAclBindingDeleteResults(Collection<AclDeleteResult.AclBindingDeleteResult> aclBindingDeleteResults, boolean toUserResource) {
        if (aclBindingDeleteResults.isEmpty()) {
            return aclBindingDeleteResults;
        }
        ArrayList<AclDeleteResult.AclBindingDeleteResult> convertedAclBindingDeleteResults = new ArrayList<AclDeleteResult.AclBindingDeleteResult>();
        for (AclDeleteResult.AclBindingDeleteResult aclBindingDeleteResult : aclBindingDeleteResults) {
            if (aclBindingDeleteResult.aclBinding() == null) continue;
            convertedAclBindingDeleteResults.add(new AclDeleteResult.AclBindingDeleteResult(this.convertAclBinding(aclBindingDeleteResult.aclBinding(), toUserResource), (ApiException)aclBindingDeleteResult.exception().orElse(null)));
        }
        return convertedAclBindingDeleteResults;
    }

    private Iterable<AclBinding> describeAclsWithResourceIdSupport(AclBindingFilter filter, AclState aclState) {
        try {
            AclBindingFilter aclFilterWithoutClusterLinkIds = this.aclFilterWithoutClusterLinkIds(filter);
            ArrayList<AclBinding> aclBindings = new ArrayList<AclBinding>();
            boolean isAnyPrincipalWithOldFormat = this.anyPrincipalWithOldFormat(aclFilterWithoutClusterLinkIds.entryFilter());
            boolean isV2Principal = false;
            if (isAnyPrincipalWithOldFormat) {
                super.acls(aclFilterWithoutClusterLinkIds, aclState).forEach(aclBindings::add);
            } else {
                isV2Principal = SecurityUtils.parseKafkaPrincipal((String)aclFilterWithoutClusterLinkIds.entryFilter().principal()).getPrincipalType().equals("TenantUserV2*");
                if (isV2Principal) {
                    AccessControlEntryFilter wildcardPrincipalFilter = new AccessControlEntryFilter(null, aclFilterWithoutClusterLinkIds.entryFilter().host(), aclFilterWithoutClusterLinkIds.entryFilter().operation(), aclFilterWithoutClusterLinkIds.entryFilter().permissionType(), aclFilterWithoutClusterLinkIds.entryFilter().clusterLinkIds());
                    super.acls(new AclBindingFilter(aclFilterWithoutClusterLinkIds.patternFilter(), wildcardPrincipalFilter), aclState).forEach(aclBindings::add);
                } else {
                    super.acls(aclFilterWithoutClusterLinkIds, aclState).forEach(aclBindings::add);
                    this.convertAclFilter(aclFilterWithoutClusterLinkIds).ifPresent(convertedFilter -> super.acls((AclBindingFilter)convertedFilter, aclState).forEach(aclBindings::add));
                }
            }
            HashSet<AclBinding> aclBindingSet = new HashSet<AclBinding>();
            if (isAnyPrincipalWithOldFormat) {
                this.convertAclBindings(aclBindings, false).forEach(aclBinding -> aclBindingSet.add((AclBinding)aclBinding));
            } else if (isV2Principal) {
                this.convertAclBindings(aclBindings, true).forEach(aclBinding -> aclBindingSet.add((AclBinding)aclBinding));
            } else {
                String rawPrincipalName = this.unPrefixedPrincipal(SecurityUtils.parseKafkaPrincipal((String)aclFilterWithoutClusterLinkIds.entryFilter().principal()).getName());
                this.convertAclBindings(aclBindings, !rawPrincipalName.matches("[0-9]+")).forEach(aclBinding -> aclBindingSet.add((AclBinding)aclBinding));
            }
            return this.aggregateAclBindingByClusterLinkIds(aclBindingSet, filter.entryFilter().clusterLinkIds());
        }
        catch (Exception e) {
            log.error("Error while calling describeAclsWithResourceIdSupport for filter {}", (Object)filter, (Object)e);
            return super.acls(filter, aclState);
        }
    }

    protected Iterable<AclBinding> aggregateAclBindingByClusterLinkIds(Set<AclBinding> aclBindingSet, Collection<Uuid> filterLinkIds) {
        HashMap aclBindingLinkIds = new HashMap();
        for (AclBinding aclBinding : aclBindingSet) {
            AclBinding aclBindingWithoutClusterLinkIds = this.aclWithoutClusterLinkIds(aclBinding);
            aclBindingLinkIds.putIfAbsent(aclBindingWithoutClusterLinkIds, new HashSet());
            if (aclBinding.entry().clusterLinkIds().size() == 0) {
                ((Set)aclBindingLinkIds.get(aclBindingWithoutClusterLinkIds)).add(Uuid.ZERO_UUID);
                continue;
            }
            ((Set)aclBindingLinkIds.get(aclBindingWithoutClusterLinkIds)).addAll(aclBinding.entry().clusterLinkIds());
        }
        HashSet<AclBinding> aclBindings = new HashSet<AclBinding>();
        for (Map.Entry entry : aclBindingLinkIds.entrySet()) {
            AclBinding aclBinding = (AclBinding)entry.getKey();
            Set linkIds = (Set)entry.getValue();
            if (!this.matchesLinkIds(filterLinkIds, linkIds)) continue;
            if (linkIds.size() == 1 && linkIds.contains(Uuid.ZERO_UUID)) {
                linkIds.clear();
            }
            aclBindings.add(new AclBinding(aclBinding.pattern(), new AccessControlEntry(aclBinding.entry().principal(), aclBinding.entry().host(), aclBinding.entry().operation(), aclBinding.entry().permissionType(), (Collection)linkIds)));
        }
        return aclBindings;
    }

    private AclBindingFilter aclFilterWithoutClusterLinkIds(AclBindingFilter filter) {
        return new AclBindingFilter(filter.patternFilter(), new AccessControlEntryFilter(filter.entryFilter().principal(), filter.entryFilter().host(), filter.entryFilter().operation(), filter.entryFilter().permissionType()));
    }

    private boolean matchesLinkIds(Collection<Uuid> filterLinkIds, Set<Uuid> bindingLinkIds) {
        return filterLinkIds.isEmpty() || !Collections.disjoint(filterLinkIds, bindingLinkIds);
    }

    private boolean anyPrincipalWithOldFormat(AccessControlEntryFilter aceFilter) {
        return aceFilter.principal() == null;
    }

    private Iterable<AclBinding> convertAclBindings(Iterable<AclBinding> bindings, boolean toUserResource) {
        try {
            this.initializeUserMetaDataStore();
            if (this.userMetaDataStore == null) {
                log.warn("UserMetaDataStore could not be loaded. Returning original bindings.");
                return bindings;
            }
            ArrayList<AclBinding> convertedBindings = new ArrayList<AclBinding>();
            for (AclBinding binding : bindings) {
                convertedBindings.add(this.convertAclBinding(binding, toUserResource));
            }
            return convertedBindings;
        }
        catch (Exception e) {
            log.error("Ran into an exception while converting bindings.", (Throwable)e);
            return bindings;
        }
    }

    private AclBinding convertAclBinding(AclBinding binding, boolean toUserResource) {
        Optional<String> convertedPrincipalName;
        this.initializeUserMetaDataStore();
        if (this.userMetaDataStore == null) {
            log.warn("UserMetaDataStore could not be loaded. Returning original binding.");
            return binding;
        }
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)binding.entry().principal());
        String principalName = this.unPrefixedPrincipal(principal.getName());
        if (principalName.isEmpty() || !principalName.matches("[0-9]+") == toUserResource || principalName.startsWith("pool")) {
            log.debug("Returning original binding for principalName {}", (Object)principalName);
            return binding;
        }
        Optional<String> optional = convertedPrincipalName = toUserResource ? this.userMetaDataStore.userIdToUserResourceId(principalName) : this.userMetaDataStore.userResourceIdToUserId(principalName);
        if (!convertedPrincipalName.isPresent()) {
            if (this.mtAuthorizerMetrics != null) {
                this.mtAuthorizerMetrics.recordMissingMappingMetric();
            }
            log.warn("UserId <-> UserResourceID mapping for User : {} is missing while converting aclBinding", (Object)principalName);
            return binding;
        }
        String newPrincipalString = new KafkaPrincipal("TenantUser", this.tenantPrefix(principal.getName()) + convertedPrincipalName.get()).toString();
        AccessControlEntry oldEntry = binding.entry();
        AccessControlEntry newEntry = new AccessControlEntry(newPrincipalString, oldEntry.host(), oldEntry.operation(), oldEntry.permissionType(), oldEntry.clusterLinkIds());
        return new AclBinding(binding.pattern(), newEntry);
    }

    private List<AclBindingFilter> convertAclFilters(List<AclBindingFilter> filters) {
        try {
            this.initializeUserMetaDataStore();
            if (this.userMetaDataStore == null) {
                log.warn("UserMetaDataStore could not be loaded. Returning original filters.");
                return filters;
            }
            ArrayList<AclBindingFilter> newFilters = new ArrayList<AclBindingFilter>();
            for (AclBindingFilter filter : filters) {
                Optional<AclBindingFilter> newFilter = this.convertAclFilter(filter);
                newFilters.add(newFilter.isPresent() ? newFilter.get() : filter);
            }
            return newFilters;
        }
        catch (Exception e) {
            log.error("Ran into an exception while converting filters.", (Throwable)e);
            return filters;
        }
    }

    private Optional<AclBindingFilter> convertAclFilter(AclBindingFilter filter) {
        Optional<String> convertedPrincipalName;
        this.initializeUserMetaDataStore();
        if (this.userMetaDataStore == null) {
            log.warn("UserMetaDataStore could not be loaded. Returning no filter.");
            return Optional.empty();
        }
        if (this.anyPrincipalWithOldFormat(filter.entryFilter())) {
            return Optional.of(filter);
        }
        if (SecurityUtils.parseKafkaPrincipal((String)filter.entryFilter().principal()).getPrincipalType().equals("TenantUserV2*")) {
            AccessControlEntryFilter wildcardPrincipalFilter = new AccessControlEntryFilter(null, filter.entryFilter().host(), filter.entryFilter().operation(), filter.entryFilter().permissionType(), filter.entryFilter().clusterLinkIds());
            return Optional.of(new AclBindingFilter(filter.patternFilter(), wildcardPrincipalFilter));
        }
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)filter.entryFilter().principal());
        String principalName = this.unPrefixedPrincipal(principal.getName());
        Optional<String> optional = convertedPrincipalName = principalName.matches("[0-9]+") ? this.userMetaDataStore.userIdToUserResourceId(principalName) : this.userMetaDataStore.userResourceIdToUserId(principalName);
        if (!convertedPrincipalName.isPresent()) {
            if (this.mtAuthorizerMetrics != null) {
                this.mtAuthorizerMetrics.recordMissingMappingMetric();
            }
            log.warn("UserId <-> UserResourceID mapping for User : {} is missing while converting the filter", (Object)principalName);
            return Optional.empty();
        }
        String newPrincipalString = new KafkaPrincipal("TenantUser", this.tenantPrefix(principal.getName()) + convertedPrincipalName.get()).toString();
        AccessControlEntryFilter oldFilterEntry = filter.entryFilter();
        AccessControlEntryFilter newFilterEntry = new AccessControlEntryFilter(newPrincipalString, oldFilterEntry.host(), oldFilterEntry.operation(), oldFilterEntry.permissionType(), oldFilterEntry.clusterLinkIds());
        return Optional.of(new AclBindingFilter(filter.patternFilter(), newFilterEntry));
    }

    private String unPrefixedPrincipal(String principal) {
        int index = principal.indexOf("_");
        if (index == -1) {
            return principal;
        }
        return principal.substring(index + 1);
    }

    private String tenantPrefix(String name) {
        int index = name.indexOf("_");
        if (index == -1) {
            throw new InvalidRequestException("Invalid tenant principal in ACL: " + name);
        }
        return name.substring(0, index + 1);
    }

    private boolean inScope(String principalStr, String tenantPrefix) {
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        if (tenantPrefix != null && !tenantPrefix.isEmpty()) {
            return MultiTenantPrincipal.isTenantPrincipal((KafkaPrincipal)principal) && principal.getName().startsWith(tenantPrefix);
        }
        return !MultiTenantPrincipal.isTenantPrincipal((KafkaPrincipal)principal);
    }

    boolean exceedsAclLimit(String tenantPrefix, List<AclBinding> newAclBindings, int maxAclsPerTenant) {
        boolean exceedsLimit;
        if (maxAclsPerTenant == Integer.MAX_VALUE) {
            return false;
        }
        String tenantId = tenantPrefix.substring(0, tenantPrefix.length() - 1);
        boolean bl = exceedsLimit = this.config.getTenantAclCount(tenantId) + newAclBindings.size() > maxAclsPerTenant;
        if (!exceedsLimit) {
            return false;
        }
        Iterable<AclBinding> existingAcls = this.acls(AclBindingFilter.ANY);
        HashSet allAclBindings = new HashSet();
        StreamSupport.stream(existingAcls.spliterator(), false).filter(binding -> this.inScope(binding.entry().principal(), tenantPrefix)).forEach(binding -> allAclBindings.add(this.aclWithoutClusterLinkIds((AclBinding)binding)));
        int countBeforeUpdate = allAclBindings.size();
        newAclBindings.forEach(binding -> {
            AclBinding aclBindingWithoutClusterLink = this.aclWithoutClusterLinkIds((AclBinding)binding);
            boolean isResourceId = this.principalIdType(binding.entry().principal()).contains(RESOURCE_ID);
            if (isResourceId && this.supportUserResourceId) {
                allAclBindings.add(this.convertAclBinding(aclBindingWithoutClusterLink, false));
            } else {
                allAclBindings.add(aclBindingWithoutClusterLink);
            }
        });
        int countAfterUpdate = allAclBindings.size();
        return countAfterUpdate > maxAclsPerTenant && countAfterUpdate > countBeforeUpdate;
    }

    private Set<AclBinding> tenantAclBinding(String tenantPrefix) {
        HashSet<AclBinding> aclBindings = new HashSet<AclBinding>();
        StreamSupport.stream(super.acls(AclBindingFilter.ANY).spliterator(), false).filter(binding -> this.inScope(binding.entry().principal(), tenantPrefix)).forEach(aclBinding -> aclBindings.add((AclBinding)aclBinding));
        return aclBindings;
    }

    private AclBinding aclWithoutClusterLinkIds(AclBinding binding) {
        AccessControlEntry ace = binding.entry();
        if (ace.clusterLinkIds().isEmpty()) {
            return binding;
        }
        return new AclBinding(binding.pattern(), new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType()));
    }

    private void checkAclsEnabled() {
        if (this.authorizationDisabled) {
            throw new InvalidRequestException("ACLs are not enabled on this broker");
        }
    }

    public boolean isAuditLogEnabled() {
        return this.auditLogEnabled;
    }

    protected Metrics metrics() {
        return this.mtAuthorizerMetrics.metrics();
    }

    protected void tenantAuthorizerMetrics() {
        this.mtAuthorizerMetrics = new TenantAuthorizerMetrics(new Metrics());
        this.config.setMetrics(this.metrics());
    }

    private String principalIdType(String principal) {
        if (principal == null) {
            return INTEGER_ID;
        }
        KafkaPrincipal kafkaPrincipal = SecurityUtils.parseKafkaPrincipal((String)principal);
        String principalName = this.unPrefixedPrincipal(kafkaPrincipal.getName());
        if (!principalName.matches("[0-9]+")) {
            return RESOURCE_ID;
        }
        return INTEGER_ID;
    }

    protected void recordCreateAclMetric(String principal) {
        this.mtAuthorizerMetrics.createAclSensor.get(this.principalIdType(principal)).record();
    }

    protected void recordDescribeAclMetric(String principal) {
        this.mtAuthorizerMetrics.describeAclSensor.get(this.principalIdType(principal)).record();
    }

    protected void recordDeleteAclMetric(String principal) {
        this.mtAuthorizerMetrics.deleteAclSensor.get(this.principalIdType(principal)).record();
    }

    public static class TenantAuthorizerMetrics {
        private static final String AUTHORIZER_AUTHORIZATION_DENIED_SENSOR = "user-account-request-authorization-denied";
        private static final String USER_ID_TO_RESOURCE_ID_MAPPING_MISSING_SENSOR = "user-id-to-resource-id-mapping-missing";
        public static final String USER_ACCOUNT_REQUEST_DENIED_RATE_PER_MINUTE = "user-account-request-denied-rate-per-minute";
        public static final String USER_ID_TO_RESOURCE_ID_MAPPING_MISSING_RATE_PER_MINUTE = "user-id-to-resource-id-mapping-missing-rate-per-minute";
        public static final String CREATE_ACL_REQUEST_SENSOR = "create-acl-request-";
        public static final String DESCRIBE_ACL_REQUEST_SENSOR = "describe-acl-request-";
        public static final String DELETE_ACL_REQUEST_SENSOR = "delete-acl-request-";
        public static final String CREATE_ACL_REQUEST_RATE = "create-acl-request-rate";
        public static final String DESCRIBE_ACL_REQUEST_RATE = "describe-acl-request-rate";
        public static final String DELETE_ACL_REQUEST_RATE = "delete-acl-request-rate";
        private final Time time;
        private final Metrics metrics;
        private Sensor authorizationUserAccountRequestDeniedSensor = null;
        private Sensor userIdToResourceIdMappingMissingSensor = null;
        private Map<String, Sensor> createAclSensor = new HashMap<String, Sensor>();
        private Map<String, Sensor> describeAclSensor = new HashMap<String, Sensor>();
        private Map<String, Sensor> deleteAclSensor = new HashMap<String, Sensor>();

        TenantAuthorizerMetrics(Metrics metrics) {
            this.authorizationUserAccountRequestDeniedSensor = metrics.sensor(AUTHORIZER_AUTHORIZATION_DENIED_SENSOR);
            this.authorizationUserAccountRequestDeniedSensor.add(metrics.metricName(USER_ACCOUNT_REQUEST_DENIED_RATE_PER_MINUTE, "confluent-authorizer-metrics", "The number of authorization denied per minute for user accounts requests"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            this.userIdToResourceIdMappingMissingSensor = metrics.sensor(USER_ID_TO_RESOURCE_ID_MAPPING_MISSING_SENSOR);
            this.userIdToResourceIdMappingMissingSensor.add(metrics.metricName(USER_ID_TO_RESOURCE_ID_MAPPING_MISSING_RATE_PER_MINUTE, "confluent-authorizer-metrics", "The number missing mapping of userId to resourceId per minute for acl operation requests"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            for (String principalType : new String[]{MultiTenantAuthorizer.INTEGER_ID, MultiTenantAuthorizer.RESOURCE_ID}) {
                this.createAclSensor.put(principalType, metrics.sensor(CREATE_ACL_REQUEST_SENSOR + principalType));
                this.createAclSensor.get(principalType).add(metrics.metricName(CREATE_ACL_REQUEST_RATE, "confluent-authorizer-metrics", "Number of create ACL requests per second.", new String[]{"principal-type", principalType}), (MeasurableStat)new Rate());
                this.describeAclSensor.put(principalType, metrics.sensor(DESCRIBE_ACL_REQUEST_SENSOR + principalType));
                this.describeAclSensor.get(principalType).add(metrics.metricName(DESCRIBE_ACL_REQUEST_RATE, "confluent-authorizer-metrics", "Number of describe ACL requests per second.", new String[]{"principal-type", principalType}), (MeasurableStat)new Rate());
                this.deleteAclSensor.put(principalType, metrics.sensor(DELETE_ACL_REQUEST_SENSOR + principalType));
                this.deleteAclSensor.get(principalType).add(metrics.metricName(DELETE_ACL_REQUEST_RATE, "confluent-authorizer-metrics", "Number of delete ACL requests per second.", new String[]{"principal-type", principalType}), (MeasurableStat)new Rate());
            }
            this.time = Time.SYSTEM;
            this.metrics = metrics;
        }

        public void recordAuthorizationDeniedMetric(AuthorizableRequestContext requestContext, List<AuthorizationResult> results, List<Action> authorizeActions) {
            try {
                if (requestContext.principal() instanceof MultiTenantPrincipal) {
                    MultiTenantPrincipal principal = (MultiTenantPrincipal)requestContext.principal();
                    if (principal.tenantMetadata().isServiceAccount) {
                        return;
                    }
                    int deniedCount = 0;
                    for (int i = 0; i < results.size(); ++i) {
                        if (results.get(i) == AuthorizationResult.ALLOWED || !authorizeActions.get(i).logIfDenied()) continue;
                        ++deniedCount;
                    }
                    if (deniedCount > 0) {
                        this.authorizationUserAccountRequestDeniedSensor.record((double)deniedCount, this.time.milliseconds(), false);
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while recording multi-tenant authorizer metrics", (Throwable)e);
            }
        }

        private void recordMissingMappingMetric() {
            this.userIdToResourceIdMappingMissingSensor.record(1.0, this.time.milliseconds(), false);
        }

        private Metrics metrics() {
            return this.metrics;
        }
    }
}

