/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.AbstractPartitionSensorCreator;
import io.confluent.kafka.multitenant.metrics.HotPartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;

public class HotPartitionSensors {
    private static final double HOT_PARTITION_OCCURRENCE_VALUE = 1.0;
    private final String tenant;
    private final Metrics metrics;
    private final HotPartitionSensorBuilder hotPartitionSensorBuilder;

    public HotPartitionSensors(TenantMetrics.TenantMetricsContext context, Metrics metrics, HotPartitionSensorBuilder hotPartitionSensorBuilder) {
        this.tenant = context.principal().tenantMetadata().tenantName;
        this.metrics = metrics;
        this.hotPartitionSensorBuilder = hotPartitionSensorBuilder;
    }

    public void recordHotPartitionIn(TopicPartition tp, long currentTimeMs) {
        Sensor hotPartitionInSensor = this.getOrCreateHotPartitionSensor(tp, HotPartitionSensorCategory.IN, this.metrics);
        hotPartitionInSensor.record(1.0, currentTimeMs);
    }

    public void recordHotPartitionOut(TopicPartition tp, long currentTimeMs) {
        Sensor hotPartitionOutSensor = this.getOrCreateHotPartitionSensor(tp, HotPartitionSensorCategory.OUT, this.metrics);
        hotPartitionOutSensor.record(1.0, currentTimeMs);
    }

    private Sensor getOrCreateHotPartitionSensor(TopicPartition tp, HotPartitionSensorCategory category, Metrics metrics) {
        Sensor hotPartitionSensor = category.sensors.get(tp);
        if (hotPartitionSensor != null && !TenantMetrics.isExpired(metrics, hotPartitionSensor)) {
            return hotPartitionSensor;
        }
        HotPartitionSensorCreator hotPartitionSensorCreator = new HotPartitionSensorCreator(category.hotPartitionMetricName, this.tenant, tp);
        String hotPartitionSensorName = hotPartitionSensorCreator.sensorName(category.hotPartitionMetricName);
        Map<String, HotPartitionSensorCreator> sensorCreators = Collections.singletonMap(hotPartitionSensorName, hotPartitionSensorCreator);
        Map<String, String> sensorsToFind = Collections.singletonMap(hotPartitionSensorName, hotPartitionSensorName);
        Map s = this.hotPartitionSensorBuilder.getOrCreateSensors(sensorsToFind, sensorCreators);
        Sensor sensorFound = (Sensor)s.get(hotPartitionSensorName);
        category.sensors.put(tp, sensorFound);
        return sensorFound;
    }

    private static enum HotPartitionSensorCategory {
        IN(new ConcurrentHashMap<TopicPartition, Sensor>(), "hot-partition-in"),
        OUT(new ConcurrentHashMap<TopicPartition, Sensor>(), "hot-partition-out");

        private final Map<TopicPartition, Sensor> sensors;
        private final String hotPartitionMetricName;

        private HotPartitionSensorCategory(Map<TopicPartition, Sensor> sensors, String hotPartitionMetricName) {
            this.sensors = sensors;
            this.hotPartitionMetricName = hotPartitionMetricName;
        }
    }

    private static class HotPartitionSensorCreator
    extends AbstractPartitionSensorCreator {
        HotPartitionSensorCreator(String name, String tenant, TopicPartition tp) {
            super(name, name, tenant, tp);
        }

        @Override
        protected void registerMetrics(Metrics metrics, Sensor sensor) {
            MetricName metricName = metrics.metricName(this.name, "tenant-metrics", "This metric identifies a hot partition", this.metricTags());
            sensor.add(metricName, (MeasurableStat)new Value());
        }
    }
}

