/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer.acl;

import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.PermissionType;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.metadata.authorizer.StandardAcl;

public class AclMapper {
    private static final Map<org.apache.kafka.common.resource.ResourceType, ResourceType> RESOURCE_TYPES = new HashMap<org.apache.kafka.common.resource.ResourceType, ResourceType>();
    private static final Map<AclOperation, Operation> OPERATIONS;
    private static final Map<Operation, AclOperation> ACL_OPERATIONS;
    private static final Map<AclPermissionType, PermissionType> PERMISSION_TYPES;

    public static ResourceType resourceType(org.apache.kafka.common.resource.ResourceType resourceType) {
        return AclMapper.mapValueOrFail(RESOURCE_TYPES, resourceType);
    }

    public static io.confluent.security.authorizer.ResourcePattern resourcePattern(ResourcePattern resourcePattern) {
        return new io.confluent.security.authorizer.ResourcePattern(AclMapper.resourceType(resourcePattern.resourceType()), resourcePattern.name(), resourcePattern.patternType());
    }

    public static Operation operation(AclOperation operation) {
        return AclMapper.mapValueOrFail(OPERATIONS, operation);
    }

    public static AclOperation aclOperation(Operation operation) {
        return AclMapper.mapValueOrFail(ACL_OPERATIONS, operation);
    }

    public static PermissionType permissionType(AclPermissionType permissionType) {
        return AclMapper.mapValueOrFail(PERMISSION_TYPES, permissionType);
    }

    private static <K, V> V mapValueOrFail(Map<K, V> map, K key) {
        V value = map.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Value is null for %s", key));
        }
        return value;
    }

    public static AccessRule accessRule(StandardAcl acl) {
        return new AclAccessRule(io.confluent.security.authorizer.ResourcePattern.from((ResourcePattern)acl.resourcePattern()), acl.kafkaPrincipal(), AclMapper.permissionType(acl.permissionType()), acl.host(), AclMapper.operation(acl.operation()), AclMapper.aclPolicyType(acl.permissionType()), acl.toBinding());
    }

    private static AuthorizePolicy.PolicyType aclPolicyType(AclPermissionType type) {
        switch (type) {
            case ALLOW: {
                return AuthorizePolicy.PolicyType.ALLOW_ACL;
            }
            case DENY: {
                return AuthorizePolicy.PolicyType.DENY_ACL;
            }
        }
        throw new IllegalArgumentException("Cannot convert permission type " + String.valueOf(type) + " to " + AuthorizePolicy.PolicyType.class.getName());
    }

    static {
        Stream.of(org.apache.kafka.common.resource.ResourceType.values()).forEach(kafkaResourceType -> {
            ResourceType resourceType = new ResourceType(SecurityUtils.toPascalCase((String)kafkaResourceType.name()));
            RESOURCE_TYPES.put((org.apache.kafka.common.resource.ResourceType)kafkaResourceType, resourceType);
        });
        OPERATIONS = new HashMap<AclOperation, Operation>();
        ACL_OPERATIONS = new HashMap<Operation, AclOperation>();
        Stream.of(AclOperation.values()).forEach(kafkaOperation -> {
            Operation operation = new Operation(SecurityUtils.toPascalCase((String)kafkaOperation.name()));
            OPERATIONS.put((AclOperation)kafkaOperation, operation);
            ACL_OPERATIONS.put(operation, (AclOperation)kafkaOperation);
        });
        PERMISSION_TYPES = new HashMap<AclPermissionType, PermissionType>();
        for (PermissionType permissionType : PermissionType.values()) {
            AclPermissionType kafkaPermissionType = AclPermissionType.fromString((String)permissionType.name());
            PERMISSION_TYPES.put(kafkaPermissionType, permissionType);
        }
    }
}

