/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import java.util.Optional;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;

public class DefaultDataPolicyContext {
    public final Optional<String> organizationId;
    public final Optional<SaslInternalConfigs.NetworkType> networkType;
    public final Optional<Boolean> hasSslPeerCertificate;
    public final Optional<Sensor> crossOrgDeniedSensor;

    private DefaultDataPolicyContext(Builder builder) {
        this.organizationId = builder.organizationId;
        this.networkType = builder.networkType;
        this.hasSslPeerCertificate = builder.hasSslPeerCertificate;
        this.crossOrgDeniedSensor = builder.crossOrgDeniedSensor;
    }

    public static class Builder {
        private Optional<String> organizationId = Optional.empty();
        private Optional<SaslInternalConfigs.NetworkType> networkType = Optional.empty();
        private Optional<Boolean> hasSslPeerCertificate = Optional.empty();
        private Optional<Sensor> crossOrgDeniedSensor = Optional.empty();

        public Builder() {
        }

        public Builder(String organizationId, SaslInternalConfigs.NetworkType networkType, Boolean hasSslPeerCertificate, Sensor crossOrgDeniedSensor) {
            this.organizationId = Optional.ofNullable(organizationId);
            this.networkType = Optional.ofNullable(networkType);
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
            this.crossOrgDeniedSensor = Optional.ofNullable(crossOrgDeniedSensor);
        }

        public Builder(Optional<String> organizationId, Optional<SaslInternalConfigs.NetworkType> networkType, Optional<Boolean> hasSslPeerCertificate, Sensor crossOrgDeniedSensor) {
            this.organizationId = organizationId;
            this.networkType = networkType;
            this.hasSslPeerCertificate = hasSslPeerCertificate;
            this.crossOrgDeniedSensor = Optional.ofNullable(crossOrgDeniedSensor);
        }

        public Builder(String organizationId, SaslInternalConfigs.NetworkType networkType, Boolean hasSslPeerCertificate) {
            this.organizationId = Optional.ofNullable(organizationId);
            this.networkType = Optional.ofNullable(networkType);
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
        }

        public Builder organizationId(String organizationId) {
            this.organizationId = Optional.ofNullable(organizationId);
            return this;
        }

        public Builder networkType(SaslInternalConfigs.NetworkType networkType) {
            this.networkType = Optional.ofNullable(networkType);
            return this;
        }

        public Builder hasSslPeerCertificate(Boolean hasSslPeerCertificate) {
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
            return this;
        }

        public DefaultDataPolicyContext build() {
            return new DefaultDataPolicyContext(this);
        }
    }
}

