/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketExceptions;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface ExecutionStrategy {
    public static final ExecutionStrategy SAME_TREAD = new ExecutionStrategy(){

        @Override
        public <T> T execute(Supplier<T> supplier) {
            return supplier.get();
        }

        @Override
        public <T> CompletableFuture<T> executeAsync(Supplier<CompletableFuture<T>> supplier) {
            return supplier.get();
        }
    };

    public <T> T execute(Supplier<T> var1);

    public <T> CompletableFuture<T> executeAsync(Supplier<CompletableFuture<T>> var1);

    public static ExecutionStrategy background(final Executor executor) {
        return new ExecutionStrategy(){

            @Override
            public <T> T execute(Supplier<T> supplier) {
                try {
                    return CompletableFuture.supplyAsync(supplier, executor).get();
                }
                catch (Throwable e) {
                    throw BucketExceptions.executionException(e);
                }
            }

            @Override
            public <T> CompletableFuture<T> executeAsync(Supplier<CompletableFuture<T>> supplier) {
                CompletableFuture<CompletableFuture<T>> futureToFuture = CompletableFuture.supplyAsync(supplier, executor);
                CompletableFuture resultFuture = new CompletableFuture();
                futureToFuture.whenComplete((mediateFuture, error) -> {
                    if (error != null) {
                        resultFuture.completeExceptionally((Throwable)error);
                    } else {
                        mediateFuture.whenComplete((result, err) -> {
                            if (err != null) {
                                resultFuture.completeExceptionally((Throwable)err);
                            } else {
                                resultFuture.complete(result);
                            }
                        });
                    }
                });
                return resultFuture;
            }
        };
    }

    public static ExecutionStrategy backgroundTimeBounded(final Executor executor, Duration timeout) {
        final long timeoutNanos = timeout.toNanos();
        if (timeoutNanos <= 0L) {
            throw new IllegalStateException("timeout should be positive");
        }
        return new ExecutionStrategy(){

            @Override
            public <T> T execute(Supplier<T> supplier) {
                try {
                    return CompletableFuture.supplyAsync(supplier, executor).get(timeoutNanos, TimeUnit.NANOSECONDS);
                }
                catch (Throwable e) {
                    throw BucketExceptions.executionException(e);
                }
            }

            @Override
            public <T> CompletableFuture<T> executeAsync(Supplier<CompletableFuture<T>> supplier) {
                CompletableFuture<CompletableFuture<T>> futureToFuture = CompletableFuture.supplyAsync(supplier, executor);
                CompletableFuture resultFuture = new CompletableFuture();
                futureToFuture.whenComplete((mediateFuture, error) -> {
                    if (error != null) {
                        resultFuture.completeExceptionally((Throwable)error);
                    } else {
                        mediateFuture.whenComplete((result, err) -> {
                            if (err != null) {
                                resultFuture.completeExceptionally((Throwable)err);
                            } else {
                                resultFuture.complete(result);
                            }
                        });
                    }
                });
                return resultFuture.orTimeout(timeoutNanos, TimeUnit.NANOSECONDS);
            }
        };
    }
}

