/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import java.util.Objects;

public class MutableBucketEntry {
    private RemoteBucketState state;
    private boolean stateModified;

    public MutableBucketEntry(RemoteBucketState state) {
        this.state = state;
    }

    public MutableBucketEntry(byte[] originalStateBytes) {
        this.state = originalStateBytes == null ? null : InternalSerializationHelper.deserializeState(originalStateBytes);
    }

    public boolean exists() {
        return this.state != null;
    }

    public boolean isStateModified() {
        return this.stateModified;
    }

    public void set(RemoteBucketState state) {
        this.state = Objects.requireNonNull(state);
        this.stateModified = true;
    }

    public RemoteBucketState get() {
        if (this.state == null) {
            throw new IllegalStateException("'exists' must be called before 'get'");
        }
        return this.state;
    }

    public byte[] getStateBytes(Version backwardCompatibilityVersion) {
        return InternalSerializationHelper.serializeState(this.get(), backwardCompatibilityVersion);
    }
}

