/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream;

import com.clearspring.analytics.stream.ITopK;
import com.clearspring.analytics.stream.ScoredItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentStreamSummary<T>
implements ITopK<T> {
    private final int capacity;
    private final ConcurrentHashMap<T, ScoredItem<T>> itemMap;
    private final AtomicReference<ScoredItem<T>> minVal;
    private final AtomicLong size;
    private final AtomicBoolean reachCapacity;

    public ConcurrentStreamSummary(int capacity) {
        this.capacity = capacity;
        this.minVal = new AtomicReference();
        this.size = new AtomicLong(0L);
        this.itemMap = new ConcurrentHashMap(capacity);
        this.reachCapacity = new AtomicBoolean(false);
    }

    @Override
    public boolean offer(T element) {
        return this.offer(element, 1);
    }

    @Override
    public boolean offer(T element, int incrementCount) {
        long val = incrementCount;
        ScoredItem<T> value = new ScoredItem<T>(element, incrementCount);
        ScoredItem<T> oldVal = this.itemMap.putIfAbsent(element, value);
        if (oldVal != null) {
            val = oldVal.addAndGetCount(incrementCount);
        } else if (this.reachCapacity.get() || this.size.incrementAndGet() > (long)this.capacity) {
            this.reachCapacity.set(true);
            ScoredItem<T> oldMinVal = this.minVal.getAndSet(value);
            this.itemMap.remove(oldMinVal.getItem());
            while (oldMinVal.isNewItem()) {
            }
            long count = oldMinVal.getCount();
            value.addAndGetCount(count);
            value.setError(count);
        }
        value.setNewItem(false);
        this.minVal.set(this.getMinValue());
        return val != (long)incrementCount;
    }

    private ScoredItem<T> getMinValue() {
        ScoredItem<T> minVal = null;
        for (ScoredItem<T> entry : this.itemMap.values()) {
            if (minVal != null && (entry.isNewItem() || entry.getCount() >= minVal.getCount())) continue;
            minVal = entry;
        }
        return minVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ScoredItem<T> entry : this.itemMap.values()) {
            sb.append("(" + entry.getCount() + ": " + String.valueOf(entry.getItem()) + ", e: " + entry.getError() + "),");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<T> peek(int k) {
        ArrayList<T> toReturn = new ArrayList<T>(k);
        List<ScoredItem<T>> values = this.peekWithScores(k);
        for (ScoredItem<T> value : values) {
            toReturn.add(value.getItem());
        }
        return toReturn;
    }

    public List<ScoredItem<T>> peekWithScores(int k) {
        ArrayList<ScoredItem<T>> values = new ArrayList<ScoredItem<T>>();
        for (Map.Entry<T, ScoredItem<T>> entry : this.itemMap.entrySet()) {
            ScoredItem<T> value = entry.getValue();
            values.add(new ScoredItem<T>(value.getItem(), value.getCount(), value.getError()));
        }
        Collections.sort(values);
        values = values.size() > k ? values.subList(0, k) : values;
        return values;
    }
}

