/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.command;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.parser.errors.ParseException;
import java.io.IOException;
import java.util.Objects;

public final class TestOptionsParser {
    private TestOptionsParser() {
    }

    public static <T> T parse(String[] args, Class<T> testOptionsClass) throws IOException {
        Objects.requireNonNull(args, "args");
        Objects.requireNonNull(testOptionsClass, "testOptionsClass");
        SingleCommand testOptionsParser = SingleCommand.singleCommand(testOptionsClass);
        if (args.length == 1 && ("--help".equals(args[0]) || "-h".equals(args[0]))) {
            Help.help((CommandMetadata)testOptionsParser.getCommandMetadata());
            return null;
        }
        try {
            return (T)testOptionsParser.parse(args);
        }
        catch (ParseException exception) {
            if (exception.getMessage() != null) {
                System.err.println(exception.getMessage());
            } else {
                System.err.println("Options parsing failed for an unknown reason");
            }
            System.err.println("See the -h or --help flags for usage information");
            return null;
        }
    }
}

