/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.parser;

import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.tools.test.parser.TestDirective;
import io.confluent.ksql.util.ParserUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.Token;

public final class DirectiveParser {
    static final Pattern DIRECTIVE_REGEX = Pattern.compile("--@(?<type>[a-zA-Z.]+):\\s*(?<contents>.*)");

    private DirectiveParser() {
    }

    public static TestDirective parse(Token comment) {
        NodeLocation loc = (NodeLocation)ParserUtil.getLocation((Token)comment).get();
        Matcher matcher = DIRECTIVE_REGEX.matcher(comment.getText().trim());
        if (!matcher.find()) {
            throw new ParsingException("Expected directive matching pattern " + String.valueOf(DIRECTIVE_REGEX) + " but got " + String.valueOf(comment), loc.getStartLineNumber(), loc.getStartColumnNumber());
        }
        TestDirective.Type type = TestDirective.Type.from(matcher.group("type").toLowerCase());
        String contents = matcher.group("contents");
        return new TestDirective(type, contents, loc);
    }
}

