/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.function.udaf.KudafAggregator;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.streams.MaterializationUtil;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.schema.ksql.LogicalSchema;

final class AggregateBuilderUtils {
    private static final String WINDOW_SELECT_OP = "WindowSelect";
    private static final String TO_OUTPUT_SCHEMA_OP = "ToOutputSchema";

    private AggregateBuilderUtils() {
    }

    static QueryContext windowSelectContext(ExecutionStep<?> step) {
        return QueryContext.Stacker.of((QueryContext)step.getProperties().getQueryContext()).push(new String[]{WINDOW_SELECT_OP}).getQueryContext();
    }

    static QueryContext outputContext(ExecutionStep<?> step) {
        return QueryContext.Stacker.of((QueryContext)step.getProperties().getQueryContext()).push(new String[]{TO_OUTPUT_SCHEMA_OP}).getQueryContext();
    }

    static MaterializationInfo.Builder materializationInfoBuilder(KudafAggregator<Object> aggregator, ExecutionStep<?> step, LogicalSchema aggregationSchema, LogicalSchema outputSchema) {
        QueryContext queryContext = MaterializationUtil.materializeContext(step);
        return MaterializationInfo.builder((String)StreamsUtil.buildOpName(queryContext), (LogicalSchema)aggregationSchema).map(pl -> aggregator.getResultMapper(), outputSchema, queryContext);
    }
}

