/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.collect.Streams;
import io.confluent.ksql.execution.streams.JoinParams;
import io.confluent.ksql.execution.streams.KsqlValueJoiner;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.stream.Stream;

public final class JoinParamsFactory {
    private JoinParamsFactory() {
    }

    public static JoinParams create(ColumnName keyColName, LogicalSchema leftSchema, LogicalSchema rightSchema) {
        boolean appendKey = JoinParamsFactory.neitherContain(keyColName, leftSchema, rightSchema);
        return new JoinParams(new KsqlValueJoiner(leftSchema.value().size(), rightSchema.value().size(), appendKey ? 1 : 0), JoinParamsFactory.createSchema(keyColName, leftSchema, rightSchema));
    }

    public static LogicalSchema createSchema(ColumnName keyColName, LogicalSchema leftSchema, LogicalSchema rightSchema) {
        SqlType keyType = JoinParamsFactory.throwOnKeyMismatch(leftSchema, rightSchema);
        LogicalSchema.Builder builder = LogicalSchema.builder().keyColumn(keyColName, keyType).valueColumns((Iterable)leftSchema.value()).valueColumns((Iterable)rightSchema.value());
        if (JoinParamsFactory.neitherContain(keyColName, leftSchema, rightSchema)) {
            builder.valueColumn(keyColName, keyType);
        }
        return builder.build();
    }

    private static SqlType throwOnKeyMismatch(LogicalSchema leftSchema, LogicalSchema rightSchema) {
        List leftKeyCols = leftSchema.key();
        List rightKeyCols = rightSchema.key();
        if (leftKeyCols.size() != 1 || rightKeyCols.size() != 1) {
            throw new UnsupportedOperationException("Multi-key joins not supported");
        }
        Column leftKey = (Column)leftKeyCols.get(0);
        Column rightKey = (Column)rightKeyCols.get(0);
        if (!leftKey.type().equals(rightKey.type())) {
            throw new KsqlException("Invalid join. Key types differ: " + String.valueOf(leftKey.type()) + " vs " + String.valueOf(rightKey.type()));
        }
        return leftKey.type();
    }

    private static boolean neitherContain(ColumnName keyColName, LogicalSchema leftSchema, LogicalSchema rightSchema) {
        return Streams.concat((Stream[])new Stream[]{leftSchema.value().stream(), rightSchema.value().stream()}).noneMatch(c -> c.name().equals((Object)keyColName));
    }
}

