/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamGroupByV1;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSelectKeyV1;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableGroupByV1;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.AggregateParamsFactory;
import io.confluent.ksql.execution.streams.ForeignKeyTableTableJoinBuilder;
import io.confluent.ksql.execution.streams.SourceBuilder;
import io.confluent.ksql.execution.streams.SourceBuilderV1;
import io.confluent.ksql.execution.streams.SqlPredicateFactory;
import io.confluent.ksql.execution.streams.StreamAggregateBuilder;
import io.confluent.ksql.execution.streams.StreamFilterBuilder;
import io.confluent.ksql.execution.streams.StreamFlatMapBuilder;
import io.confluent.ksql.execution.streams.StreamGroupByBuilder;
import io.confluent.ksql.execution.streams.StreamGroupByBuilderV1;
import io.confluent.ksql.execution.streams.StreamSelectBuilder;
import io.confluent.ksql.execution.streams.StreamSelectKeyBuilder;
import io.confluent.ksql.execution.streams.StreamSelectKeyBuilderV1;
import io.confluent.ksql.execution.streams.StreamSinkBuilder;
import io.confluent.ksql.execution.streams.StreamStreamJoinBuilder;
import io.confluent.ksql.execution.streams.StreamTableJoinBuilder;
import io.confluent.ksql.execution.streams.StreamsFactories;
import io.confluent.ksql.execution.streams.TableAggregateBuilder;
import io.confluent.ksql.execution.streams.TableFilterBuilder;
import io.confluent.ksql.execution.streams.TableGroupByBuilder;
import io.confluent.ksql.execution.streams.TableGroupByBuilderV1;
import io.confluent.ksql.execution.streams.TableSelectBuilder;
import io.confluent.ksql.execution.streams.TableSelectKeyBuilder;
import io.confluent.ksql.execution.streams.TableSinkBuilder;
import io.confluent.ksql.execution.streams.TableSuppressBuilder;
import io.confluent.ksql.execution.streams.TableTableJoinBuilder;
import io.confluent.ksql.execution.transform.sqlpredicate.SqlPredicate;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Windowed;

public final class KSPlanBuilder
implements PlanBuilder {
    private final RuntimeBuildContext buildContext;
    private final SqlPredicateFactory sqlPredicateFactory;
    private final AggregateParamsFactory aggregateParamFactory;
    private final StreamsFactories streamsFactories;

    public KSPlanBuilder(RuntimeBuildContext buildContext) {
        this(buildContext, SqlPredicate::new, new AggregateParamsFactory(), StreamsFactories.create(buildContext.getKsqlConfig()));
    }

    public KSPlanBuilder(RuntimeBuildContext buildContext, SqlPredicateFactory sqlPredicateFactory, AggregateParamsFactory aggregateParamFactory, StreamsFactories streamsFactories) {
        this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        this.sqlPredicateFactory = Objects.requireNonNull(sqlPredicateFactory, "sqlPredicateFactory");
        this.aggregateParamFactory = Objects.requireNonNull(aggregateParamFactory, "aggregateParamsFactory");
        this.streamsFactories = Objects.requireNonNull(streamsFactories, "streamsFactories");
    }

    public <K> KStreamHolder<K> visitStreamFilter(StreamFilter<K> streamFilter, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamFilter.getSource().build((PlanBuilder)this, planInfo);
        return StreamFilterBuilder.build(source, streamFilter, this.buildContext, this.sqlPredicateFactory);
    }

    public <K> KGroupedStreamHolder visitStreamGroupBy(StreamGroupByV1<K> streamGroupBy, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamGroupBy.getSource().build((PlanBuilder)this, planInfo);
        return new StreamGroupByBuilderV1(this.buildContext, this.streamsFactories.getGroupedFactory()).build(source, streamGroupBy.getProperties().getQueryContext(), streamGroupBy.getInternalFormats(), streamGroupBy.getGroupByExpressions());
    }

    public <K> KGroupedStreamHolder visitStreamGroupBy(StreamGroupBy<K> streamGroupBy, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamGroupBy.getSource().build((PlanBuilder)this, planInfo);
        return new StreamGroupByBuilder(this.buildContext, this.streamsFactories.getGroupedFactory()).build(source, streamGroupBy.getProperties().getQueryContext(), streamGroupBy.getInternalFormats(), streamGroupBy.getGroupByExpressions());
    }

    public KGroupedStreamHolder visitStreamGroupByKey(StreamGroupByKey streamGroupByKey, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamGroupByKey.getSource().build((PlanBuilder)this, planInfo);
        return new StreamGroupByBuilder(this.buildContext, this.streamsFactories.getGroupedFactory()).build(source, streamGroupByKey);
    }

    public KTableHolder<GenericKey> visitStreamAggregate(StreamAggregate streamAggregate, PlanInfo planInfo) {
        KGroupedStreamHolder source = (KGroupedStreamHolder)streamAggregate.getSource().build((PlanBuilder)this, planInfo);
        return StreamAggregateBuilder.build(source, streamAggregate, this.buildContext, this.streamsFactories.getMaterializedFactory(), this.aggregateParamFactory);
    }

    public <K> KStreamHolder<K> visitStreamSelect(StreamSelect<K> streamSelect, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamSelect.getSource().build((PlanBuilder)this, planInfo);
        return StreamSelectBuilder.build(source, streamSelect, this.buildContext);
    }

    public <K> KStreamHolder<K> visitFlatMap(StreamFlatMap<K> streamFlatMap, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamFlatMap.getSource().build((PlanBuilder)this, planInfo);
        return StreamFlatMapBuilder.build(source, streamFlatMap, this.buildContext);
    }

    public KStreamHolder<GenericKey> visitStreamSelectKey(StreamSelectKeyV1 streamSelectKey, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamSelectKey.getSource().build((PlanBuilder)this, planInfo);
        return StreamSelectKeyBuilderV1.build(source, streamSelectKey, this.buildContext);
    }

    public <K> KStreamHolder<K> visitStreamSelectKey(StreamSelectKey<K> streamSelectKey, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamSelectKey.getSource().build((PlanBuilder)this, planInfo);
        return StreamSelectKeyBuilder.build(source, streamSelectKey, this.buildContext);
    }

    public <K> KStreamHolder<K> visitStreamSink(StreamSink<K> streamSink, PlanInfo planInfo) {
        KStreamHolder source = (KStreamHolder)streamSink.getSource().build((PlanBuilder)this, planInfo);
        StreamSinkBuilder.build(source, streamSink, this.buildContext);
        return source;
    }

    public KStreamHolder<GenericKey> visitStreamSource(StreamSource streamSource, PlanInfo planInfo) {
        return SourceBuilderV1.instance().buildStream(this.buildContext, streamSource, this.streamsFactories.getConsumedFactory());
    }

    public KStreamHolder<Windowed<GenericKey>> visitWindowedStreamSource(WindowedStreamSource windowedStreamSource, PlanInfo planInfo) {
        return SourceBuilderV1.instance().buildWindowedStream(this.buildContext, windowedStreamSource, this.streamsFactories.getConsumedFactory());
    }

    public <K> KStreamHolder<K> visitStreamStreamJoin(StreamStreamJoin<K> join, PlanInfo planInfo) {
        KStreamHolder left = (KStreamHolder)join.getLeftSource().build((PlanBuilder)this, planInfo);
        KStreamHolder right = (KStreamHolder)join.getRightSource().build((PlanBuilder)this, planInfo);
        return StreamStreamJoinBuilder.build(left, right, join, this.buildContext, this.streamsFactories.getStreamJoinedFactory());
    }

    public <K> KStreamHolder<K> visitStreamTableJoin(StreamTableJoin<K> join, PlanInfo planInfo) {
        KTableHolder right = (KTableHolder)join.getRightSource().build((PlanBuilder)this, planInfo);
        KStreamHolder left = (KStreamHolder)join.getLeftSource().build((PlanBuilder)this, planInfo);
        return StreamTableJoinBuilder.build(left, right, join, this.buildContext, this.streamsFactories.getJoinedFactory());
    }

    public KTableHolder<GenericKey> visitTableSource(TableSourceV1 tableSourceV1, PlanInfo planInfo) {
        return SourceBuilderV1.instance().buildTable(this.buildContext, (SourceStep<KTableHolder<GenericKey>>)tableSourceV1, this.streamsFactories.getConsumedFactory(), this.streamsFactories.getMaterializedFactory(), planInfo);
    }

    public KTableHolder<GenericKey> visitTableSource(TableSource tableSource, PlanInfo planInfo) {
        return SourceBuilder.instance().buildTable(this.buildContext, (SourceStep<KTableHolder<GenericKey>>)tableSource, this.streamsFactories.getConsumedFactory(), this.streamsFactories.getMaterializedFactory(), planInfo);
    }

    public KTableHolder<Windowed<GenericKey>> visitWindowedTableSource(WindowedTableSource windowedTableSource, PlanInfo planInfo) {
        return SourceBuilderV1.instance().buildWindowedTable(this.buildContext, (SourceStep<KTableHolder<Windowed<GenericKey>>>)windowedTableSource, this.streamsFactories.getConsumedFactory(), this.streamsFactories.getMaterializedFactory(), planInfo);
    }

    public KTableHolder<Windowed<GenericKey>> visitStreamWindowedAggregate(StreamWindowedAggregate aggregate, PlanInfo planInfo) {
        KGroupedStreamHolder source = (KGroupedStreamHolder)aggregate.getSource().build((PlanBuilder)this, planInfo);
        return StreamAggregateBuilder.build(source, aggregate, this.buildContext, this.streamsFactories.getMaterializedFactory(), this.aggregateParamFactory);
    }

    public KTableHolder<GenericKey> visitTableAggregate(TableAggregate aggregate, PlanInfo planInfo) {
        KGroupedTableHolder source = (KGroupedTableHolder)aggregate.getSource().build((PlanBuilder)this, planInfo);
        return TableAggregateBuilder.build(source, aggregate, this.buildContext, this.streamsFactories.getMaterializedFactory(), this.aggregateParamFactory);
    }

    public <K> KTableHolder<K> visitTableFilter(TableFilter<K> tableFilter, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableFilter.getSource().build((PlanBuilder)this, planInfo);
        return TableFilterBuilder.build(source, tableFilter, this.buildContext, this.sqlPredicateFactory);
    }

    public <K> KGroupedTableHolder visitTableGroupBy(TableGroupByV1<K> tableGroupBy, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableGroupBy.getSource().build((PlanBuilder)this, planInfo);
        return new TableGroupByBuilderV1(this.buildContext, this.streamsFactories.getGroupedFactory()).build(source, tableGroupBy.getProperties().getQueryContext(), tableGroupBy.getInternalFormats(), tableGroupBy.getGroupByExpressions());
    }

    public <K> KGroupedTableHolder visitTableGroupBy(TableGroupBy<K> tableGroupBy, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableGroupBy.getSource().build((PlanBuilder)this, planInfo);
        return new TableGroupByBuilder(this.buildContext, this.streamsFactories.getGroupedFactory()).build(source, tableGroupBy.getProperties().getQueryContext(), tableGroupBy.getInternalFormats(), tableGroupBy.getGroupByExpressions());
    }

    public <K> KTableHolder<K> visitTableSelect(TableSelect<K> tableSelect, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableSelect.getSource().build((PlanBuilder)this, planInfo);
        return TableSelectBuilder.build(source, tableSelect, this.buildContext, tableSelect.getInternalFormats(), this.streamsFactories.getMaterializedFactory());
    }

    public <K> KTableHolder<K> visitTableSelectKey(TableSelectKey<K> tableSelectKey, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableSelectKey.getSource().build((PlanBuilder)this, planInfo);
        return TableSelectKeyBuilder.build(source, tableSelectKey, this.buildContext, this.streamsFactories.getMaterializedFactory());
    }

    public <K> KTableHolder<K> visitTableSink(TableSink<K> tableSink, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableSink.getSource().build((PlanBuilder)this, planInfo);
        TableSinkBuilder.build(source, tableSink, this.buildContext);
        return source;
    }

    public <K> KTableHolder<K> visitTableSuppress(TableSuppress<K> tableSuppress, PlanInfo planInfo) {
        KTableHolder source = (KTableHolder)tableSuppress.getSource().build((PlanBuilder)this, planInfo);
        return new TableSuppressBuilder().build(source, tableSuppress, this.buildContext, source.getExecutionKeyFactory());
    }

    public <K> KTableHolder<K> visitTableTableJoin(TableTableJoin<K> tableTableJoin, PlanInfo planInfo) {
        KTableHolder left = (KTableHolder)tableTableJoin.getLeftSource().build((PlanBuilder)this, planInfo);
        KTableHolder right = (KTableHolder)tableTableJoin.getRightSource().build((PlanBuilder)this, planInfo);
        return TableTableJoinBuilder.build(left, right, tableTableJoin);
    }

    public <KLeftT, KRightT> KTableHolder<KLeftT> visitForeignKeyTableTableJoin(ForeignKeyTableTableJoin<KLeftT, KRightT> foreignKeyTableTableJoin, PlanInfo planInfo) {
        KTableHolder left = (KTableHolder)foreignKeyTableTableJoin.getLeftSource().build((PlanBuilder)this, planInfo);
        KTableHolder right = (KTableHolder)foreignKeyTableTableJoin.getRightSource().build((PlanBuilder)this, planInfo);
        return ForeignKeyTableTableJoinBuilder.build(left, right, foreignKeyTableTableJoin, this.buildContext);
    }
}

