/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.SourceBuilderBase;
import io.confluent.ksql.execution.streams.SourceBuilderUtils;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

final class SourceBuilder
extends SourceBuilderBase {
    private static final SourceBuilder instance = new SourceBuilder();

    private SourceBuilder() {
    }

    public static SourceBuilder instance() {
        return instance;
    }

    @Override
    <K> KTable<K, GenericRow> buildKTable(SourceStep<?> streamSource, RuntimeBuildContext buildContext, Consumed<K, GenericRow> consumed, Function<K, Collection<?>> keyGenerator, Materialized<K, GenericRow, KeyValueStore<Bytes, byte[]>> materialized, Serde<GenericRow> valueSerde, String stateStoreName, PlanInfo planInfo) {
        KTable source = buildContext.getStreamsBuilder().table(streamSource.getTopicName(), consumed);
        boolean forceMaterialization = !planInfo.isRepartitionedInPlan(streamSource);
        KTable maybeMaterialized = forceMaterialization ? source.transformValues(new AddPseudoColumnsToMaterialize(streamSource.getPseudoColumnVersion(), streamSource.getSourceSchema().headers()), materialized, new String[0]) : source.transformValues(new AddPseudoColumnsToMaterialize(streamSource.getPseudoColumnVersion(), streamSource.getSourceSchema().headers()), new String[0]);
        return maybeMaterialized.transformValues(new AddRemainingPseudoAndKeyCols<K>(keyGenerator, streamSource.getPseudoColumnVersion(), streamSource.getSourceSchema().headers()), new String[0]);
    }

    @Override
    Materialized<GenericKey, GenericRow, KeyValueStore<Bytes, byte[]>> buildTableMaterialized(SourceStep<KTableHolder<GenericKey>> source, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, Serde<GenericKey> sourceKeySerde, Serde<GenericRow> sourceValueSerde, String stateStoreName) {
        PhysicalSchema physicalSchema = SourceBuilder.getPhysicalSchemaWithPseudoColumnsToMaterialize(source);
        QueryContext queryContext = SourceBuilderUtils.addMaterializedContext(source);
        Serde<GenericRow> valueSerdeToMaterialize = SourceBuilderUtils.getValueSerde(buildContext, source.getFormats().getValueFormat().copyWithoutProperty("schemaId"), physicalSchema, queryContext);
        Serde<GenericKey> keySerdeToMaterialize = SourceBuilderUtils.getKeySerde(source.getFormats().getKeyFormat().copyWithoutProperty("schemaId"), physicalSchema, buildContext, queryContext);
        return materializedFactory.create(keySerdeToMaterialize, valueSerdeToMaterialize, stateStoreName);
    }

    private static PhysicalSchema getPhysicalSchemaWithPseudoColumnsToMaterialize(SourceStep<?> streamSource) {
        Formats format = ((TableSource)streamSource).getStateStoreFormats();
        LogicalSchema withPseudoCols = streamSource.getSourceSchema().withPseudoColumnsToMaterialize(streamSource.getPseudoColumnVersion());
        return PhysicalSchema.from((LogicalSchema)withPseudoCols, (SerdeFeatures)format.getKeyFeatures(), (SerdeFeatures)format.getValueFeatures());
    }

    private static class AddPseudoColumnsToMaterialize<K>
    implements ValueTransformerWithKeySupplier<K, GenericRow, GenericRow> {
        private final int pseudoColumnVersion;
        private final int numPseudoColumnsToMaterialize;
        private final List<Column> headerColumns;

        AddPseudoColumnsToMaterialize(int pseudoColumnVersion, List<Column> headerColumns) {
            this.pseudoColumnVersion = pseudoColumnVersion;
            this.numPseudoColumnsToMaterialize = (int)SystemColumns.pseudoColumnNames((int)pseudoColumnVersion).stream().filter(SystemColumns::mustBeMaterializedForTableJoins).count() + headerColumns.size();
            this.headerColumns = headerColumns;
        }

        public ValueTransformerWithKey<K, GenericRow, GenericRow> get() {
            return new ValueTransformerWithKey<K, GenericRow, GenericRow>(){
                private ProcessorContext processorContext;

                public void init(ProcessorContext processorContext) {
                    this.processorContext = Objects.requireNonNull(processorContext, "processorContext");
                }

                public GenericRow transform(K key, GenericRow row) {
                    if (row == null) {
                        return row;
                    }
                    row.ensureAdditionalCapacity(numPseudoColumnsToMaterialize);
                    for (Column col : headerColumns) {
                        if (col.headerKey().isPresent()) {
                            row.append((Object)SourceBuilderUtils.extractHeader(this.processorContext.headers(), (String)col.headerKey().get()));
                            continue;
                        }
                        row.append(SourceBuilderUtils.createHeaderData(this.processorContext.headers()));
                    }
                    if (pseudoColumnVersion >= 1) {
                        int partition = this.processorContext.partition();
                        long offset = this.processorContext.offset();
                        row.append((Object)partition);
                        row.append((Object)offset);
                    }
                    return row;
                }

                public void close() {
                }
            };
        }
    }

    private static class AddRemainingPseudoAndKeyCols<K>
    implements ValueTransformerWithKeySupplier<K, GenericRow, GenericRow> {
        private final Function<K, Collection<?>> keyGenerator;
        private final int pseudoColumnVersion;
        private final int pseudoColumnsToAdd;
        private final List<Column> headerColumns;

        AddRemainingPseudoAndKeyCols(Function<K, Collection<?>> keyGenerator, int pseudoColumnVersion, List<Column> headerColumns) {
            this.keyGenerator = Objects.requireNonNull(keyGenerator, "keyGenerator");
            this.pseudoColumnVersion = pseudoColumnVersion;
            this.pseudoColumnsToAdd = (int)SystemColumns.pseudoColumnNames((int)pseudoColumnVersion).stream().filter(col -> !SystemColumns.mustBeMaterializedForTableJoins((ColumnName)col)).count();
            this.headerColumns = headerColumns;
        }

        public ValueTransformerWithKey<K, GenericRow, GenericRow> get() {
            return new ValueTransformerWithKey<K, GenericRow, GenericRow>(){
                private ProcessorContext processorContext;

                public void init(ProcessorContext processorContext) {
                    this.processorContext = Objects.requireNonNull(processorContext, "processorContext");
                }

                public GenericRow transform(K key, GenericRow row) {
                    int i;
                    if (row == null) {
                        return row;
                    }
                    Collection<?> keyColumns = keyGenerator.apply(key);
                    row.ensureAdditionalCapacity(pseudoColumnsToAdd);
                    for (int i2 = 0; i2 < pseudoColumnsToAdd; ++i2) {
                        row.append(null);
                    }
                    Set columnNames = SystemColumns.pseudoColumnNames((int)pseudoColumnVersion);
                    int totalPseudoColumns = columnNames.size();
                    int pseudoColumnsToShift = totalPseudoColumns - pseudoColumnsToAdd;
                    int numUserColumns = row.size() - totalPseudoColumns;
                    ArrayList<Object> pseudoCols = new ArrayList<Object>();
                    if (pseudoColumnVersion >= 0) {
                        pseudoCols.add(this.processorContext.timestamp());
                    }
                    for (i = numUserColumns; i < numUserColumns + pseudoColumnsToShift; ++i) {
                        pseudoCols.add(row.get(i));
                    }
                    for (i = 0; i < totalPseudoColumns; ++i) {
                        row.set(i + numUserColumns, pseudoCols.get(i));
                    }
                    row.appendAll(keyColumns);
                    return row;
                }

                public void close() {
                }
            };
        }
    }
}

