/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.GroupByParams;
import io.confluent.ksql.execution.streams.GroupedFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KGroupedStream;

class StreamGroupByBuilderBase {
    private final RuntimeBuildContext buildContext;
    private final GroupedFactory groupedFactory;
    private final ParamsFactory paramsFactory;

    StreamGroupByBuilderBase(RuntimeBuildContext buildContext, GroupedFactory groupedFactory, ParamsFactory paramsFactory) {
        this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        this.groupedFactory = Objects.requireNonNull(groupedFactory, "groupedFactory");
        this.paramsFactory = Objects.requireNonNull(paramsFactory, "paramsFactory");
    }

    public KGroupedStreamHolder build(KStreamHolder<GenericKey> stream, StreamGroupByKey step) {
        LogicalSchema sourceSchema = stream.getSchema();
        QueryContext queryContext = step.getProperties().getQueryContext();
        Formats formats = step.getInternalFormats();
        Grouped<GenericKey, GenericRow> grouped = StreamGroupByBuilderBase.buildGrouped(formats, sourceSchema, queryContext, this.buildContext, this.groupedFactory);
        return KGroupedStreamHolder.of((KGroupedStream)stream.getStream().groupByKey(grouped), (LogicalSchema)stream.getSchema());
    }

    public <K> KGroupedStreamHolder build(KStreamHolder<K> stream, QueryContext queryContext, Formats formats, List<Expression> groupByExpressions) {
        LogicalSchema sourceSchema = stream.getSchema();
        List groupBy = CodeGenRunner.compileExpressions(groupByExpressions.stream(), (String)"Group By", (LogicalSchema)sourceSchema, (KsqlConfig)this.buildContext.getKsqlConfig(), (FunctionRegistry)this.buildContext.getFunctionRegistry());
        ProcessingLogger logger = this.buildContext.getProcessingLogger(queryContext);
        GroupByParams params = this.paramsFactory.build(sourceSchema, groupBy, logger);
        Grouped<GenericKey, GenericRow> grouped = StreamGroupByBuilderBase.buildGrouped(formats, params.getSchema(), queryContext, this.buildContext, this.groupedFactory);
        KGroupedStream groupedStream = stream.getStream().filter((k, v) -> v != null).groupBy((k, v) -> params.getMapper().apply((GenericRow)v), grouped);
        return KGroupedStreamHolder.of((KGroupedStream)groupedStream, (LogicalSchema)params.getSchema());
    }

    private static Grouped<GenericKey, GenericRow> buildGrouped(Formats formats, LogicalSchema schema, QueryContext queryContext, RuntimeBuildContext buildContext, GroupedFactory groupedFactory) {
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)schema, (SerdeFeatures)formats.getKeyFeatures(), (SerdeFeatures)formats.getValueFeatures());
        Serde keySerde = buildContext.buildKeySerde(formats.getKeyFormat(), physicalSchema, queryContext);
        Serde valSerde = buildContext.buildValueSerde(formats.getValueFormat(), physicalSchema, queryContext);
        return groupedFactory.create(StreamsUtil.buildOpName(queryContext), keySerde, valSerde);
    }

    static interface ParamsFactory {
        public GroupByParams build(LogicalSchema var1, List<CompiledExpression> var2, ProcessingLogger var3);
    }
}

