/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamSelectKeyV1;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.StepSchemaResolver;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.function.Function;
import org.apache.kafka.streams.kstream.KStream;

public final class StreamSelectKeyBuilderV1 {
    private static final String EXP_TYPE = "SelectKey";

    private StreamSelectKeyBuilderV1() {
    }

    public static KStreamHolder<GenericKey> build(KStreamHolder<?> stream, StreamSelectKeyV1 selectKey, RuntimeBuildContext buildContext) {
        LogicalSchema sourceSchema = stream.getSchema();
        CompiledExpression expression = StreamSelectKeyBuilderV1.buildExpressionEvaluator(selectKey, buildContext, sourceSchema);
        ProcessingLogger processingLogger = buildContext.getProcessingLogger(selectKey.getProperties().getQueryContext());
        String errorMsg = "Error extracting new key using expression " + String.valueOf(selectKey.getKeyExpression());
        Function<GenericRow, Object> evaluator = val -> expression.evaluate(val, null, processingLogger, () -> errorMsg);
        LogicalSchema resultSchema = new StepSchemaResolver(buildContext.getKsqlConfig(), buildContext.getFunctionRegistry()).resolve((ExecutionStep<?>)selectKey, sourceSchema);
        KStream kstream = stream.getStream();
        KStream rekeyed = kstream.filter((key, val) -> val != null && evaluator.apply((GenericRow)val) != null).selectKey((key, val) -> GenericKey.genericKey((Object[])new Object[]{evaluator.apply((GenericRow)val)}));
        return new KStreamHolder(rekeyed, resultSchema, ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext));
    }

    private static CompiledExpression buildExpressionEvaluator(StreamSelectKeyV1 selectKey, RuntimeBuildContext buildContext, LogicalSchema sourceSchema) {
        CodeGenRunner codeGen = new CodeGenRunner(sourceSchema, buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
        return codeGen.buildCodeGenFromParseTree(selectKey.getKeyExpression(), EXP_TYPE);
    }
}

