/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.JoinParams;
import io.confluent.ksql.execution.streams.JoinParamsFactory;
import io.confluent.ksql.execution.streams.StreamJoinedFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import java.time.Duration;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.ValueJoiner;

public final class StreamStreamJoinBuilder {
    private static final String LEFT_SERDE_CTX = "Left";
    private static final String RIGHT_SERDE_CTX = "Right";

    private StreamStreamJoinBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> left, KStreamHolder<K> right, StreamStreamJoin<K> join, RuntimeBuildContext buildContext, StreamJoinedFactory streamJoinedFactory) {
        LogicalSchema rightSchema;
        LogicalSchema leftSchema;
        Formats rightFormats;
        Formats leftFormats;
        QueryContext queryContext = join.getProperties().getQueryContext();
        QueryContext.Stacker stacker = QueryContext.Stacker.of((QueryContext)queryContext);
        if (join.getJoinType().equals((Object)JoinType.RIGHT)) {
            leftFormats = join.getRightInternalFormats();
            rightFormats = join.getLeftInternalFormats();
            leftSchema = right.getSchema();
            rightSchema = left.getSchema();
        } else {
            leftFormats = join.getLeftInternalFormats();
            rightFormats = join.getRightInternalFormats();
            leftSchema = left.getSchema();
            rightSchema = right.getSchema();
        }
        PhysicalSchema leftPhysicalSchema = PhysicalSchema.from((LogicalSchema)leftSchema, (SerdeFeatures)leftFormats.getKeyFeatures(), (SerdeFeatures)leftFormats.getValueFeatures());
        Serde leftSerde = buildContext.buildValueSerde(leftFormats.getValueFormat(), leftPhysicalSchema, stacker.push(new String[]{LEFT_SERDE_CTX}).getQueryContext());
        PhysicalSchema rightPhysicalSchema = PhysicalSchema.from((LogicalSchema)rightSchema, (SerdeFeatures)rightFormats.getKeyFeatures(), (SerdeFeatures)rightFormats.getValueFeatures());
        Serde rightSerde = buildContext.buildValueSerde(rightFormats.getValueFormat(), rightPhysicalSchema, stacker.push(new String[]{RIGHT_SERDE_CTX}).getQueryContext());
        Serde keySerde = left.getExecutionKeyFactory().buildKeySerde(leftFormats.getKeyFormat(), leftPhysicalSchema, queryContext);
        StreamJoined joined = streamJoinedFactory.create(keySerde, leftSerde, rightSerde, StreamsUtil.buildOpName(queryContext), StreamsUtil.buildOpName(queryContext));
        JoinParams joinParams = JoinParamsFactory.create(join.getKeyColName(), leftSchema, rightSchema);
        JoinWindows joinWindows = join.getGraceMillis().isPresent() ? JoinWindows.ofTimeDifferenceAndGrace((Duration)join.getBeforeMillis(), (Duration)((Duration)join.getGraceMillis().get())) : JoinWindows.of((Duration)join.getBeforeMillis());
        joinWindows = joinWindows.after(join.getAfterMillis());
        return left.withStream(switch (join.getJoinType()) {
            case JoinType.LEFT -> left.getStream().leftJoin(right.getStream(), (ValueJoiner)joinParams.getJoiner(), joinWindows, joined);
            case JoinType.RIGHT -> right.getStream().leftJoin(left.getStream(), (ValueJoiner)joinParams.getJoiner(), joinWindows, joined);
            case JoinType.OUTER -> left.getStream().outerJoin(right.getStream(), (ValueJoiner)joinParams.getJoiner(), joinWindows, joined);
            case JoinType.INNER -> left.getStream().join(right.getStream(), (ValueJoiner)joinParams.getJoiner(), joinWindows, joined);
            default -> throw new IllegalStateException("invalid join type");
        }, joinParams.getSchema());
    }
}

