/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.execution.transform.select.Selection;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;

public final class TableSelectBuilder {
    private static final String PROJECT_OP = "Last";

    private TableSelectBuilder() {
    }

    public static <K> KTableHolder<K> build(KTableHolder<K> table, TableSelect<K> step, RuntimeBuildContext buildContext, Optional<Formats> formats, MaterializedFactory materializedFactory) {
        Serde valSerde;
        Serde keySerde;
        boolean forceMaterialize;
        LogicalSchema sourceSchema = table.getSchema();
        QueryContext queryContext = step.getProperties().getQueryContext();
        Selection selection = Selection.of((LogicalSchema)sourceSchema, (List)step.getKeyColumnNames(), Optional.empty(), (List)step.getSelectExpressions(), (KsqlConfig)buildContext.getKsqlConfig(), (FunctionRegistry)buildContext.getFunctionRegistry());
        SelectValueMapper selectMapper = selection.getMapper();
        ProcessingLogger logger = buildContext.getProcessingLogger(queryContext);
        Named selectName = Named.as((String)StreamsUtil.buildOpName(queryContext));
        Optional matBuilder = table.getMaterializationBuilder();
        boolean bl = forceMaterialize = !matBuilder.isPresent();
        if (formats.isPresent()) {
            Formats materializationFormat = formats.get();
            PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)selection.getSchema(), (SerdeFeatures)materializationFormat.getKeyFeatures(), (SerdeFeatures)materializationFormat.getValueFeatures());
            keySerde = buildContext.buildKeySerde(materializationFormat.getKeyFormat(), physicalSchema, queryContext);
            valSerde = buildContext.buildValueSerde(materializationFormat.getValueFormat(), physicalSchema, queryContext);
            if (forceMaterialize) {
                QueryContext.Stacker stacker = QueryContext.Stacker.of((QueryContext)step.getProperties().getQueryContext());
                String stateStoreName = StreamsUtil.buildOpName(stacker.push(new String[]{PROJECT_OP}).getQueryContext());
                Materialized materialized = materializedFactory.create(keySerde, valSerde, stateStoreName);
                KTable transFormedTable = table.getTable().transformValues(() -> new KsValueTransformer(selectMapper.getTransformer(logger)), materialized, new String[0]);
                return KTableHolder.materialized((KTable)transFormedTable, (LogicalSchema)selection.getSchema(), (ExecutionKeyFactory)table.getExecutionKeyFactory(), (MaterializationInfo.Builder)MaterializationInfo.builder((String)stateStoreName, (LogicalSchema)selection.getSchema()));
            }
        } else {
            keySerde = null;
            valSerde = null;
        }
        KTable transFormedTable = table.getTable().transformValues(() -> new KsValueTransformer(selectMapper.getTransformer(logger)), materializedFactory.create(keySerde, valSerde), selectName, new String[0]);
        Optional<MaterializationInfo.Builder> materialization = matBuilder.map(b -> b.map(pl -> selectMapper.getTransformer(pl), selection.getSchema(), queryContext));
        return table.withTable(transFormedTable, selection.getSchema()).withMaterialization(materialization);
    }
}

