/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.MaterializationUtil;
import io.confluent.ksql.execution.streams.PartitionByParams;
import io.confluent.ksql.execution.streams.PartitionByParamsFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;

public final class TableSelectKeyBuilder {
    private TableSelectKeyBuilder() {
    }

    public static <K> KTableHolder<K> build(KTableHolder<K> table, TableSelectKey<K> selectKey, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory) {
        return TableSelectKeyBuilder.build(table, selectKey, buildContext, materializedFactory, PartitionByParamsFactory::build);
    }

    @VisibleForTesting
    static <K> KTableHolder<K> build(KTableHolder<K> table, TableSelectKey<K> selectKey, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, PartitionByParamsBuilder paramsBuilder) {
        LogicalSchema sourceSchema = table.getSchema();
        QueryContext queryContext = selectKey.getProperties().getQueryContext();
        ProcessingLogger logger = buildContext.getProcessingLogger(queryContext);
        PartitionByParams params = paramsBuilder.build(sourceSchema, table.getExecutionKeyFactory(), selectKey.getKeyExpressions(), buildContext.getKsqlConfig(), buildContext.getFunctionRegistry(), logger);
        PartitionByParams.Mapper mapper = params.getMapper();
        KTable kTable = table.getTable();
        Materialized materialized = MaterializationUtil.buildMaterialized(selectKey, params.getSchema(), selectKey.getInternalFormats(), buildContext, materializedFactory, table.getExecutionKeyFactory());
        KTable reKeyed = kTable.toStream().map(mapper, Named.as((String)(queryContext.formatContext() + "-SelectKey-Mapper"))).toTable(Named.as((String)(queryContext.formatContext() + "-SelectKey")), materialized);
        MaterializationInfo.Builder materializationBuilder = MaterializationInfo.builder((String)StreamsUtil.buildOpName(MaterializationUtil.materializeContext(selectKey)), (LogicalSchema)params.getSchema());
        return KTableHolder.materialized((KTable)reKeyed, (LogicalSchema)params.getSchema(), (ExecutionKeyFactory)table.getExecutionKeyFactory().withQueryBuilder(buildContext), (MaterializationInfo.Builder)materializationBuilder);
    }

    static interface PartitionByParamsBuilder {
        public <K> PartitionByParams<K> build(LogicalSchema var1, ExecutionKeyFactory<K> var2, List<Expression> var3, KsqlConfig var4, FunctionRegistry var5, ProcessingLogger var6);
    }
}

