/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;

final class TableRowValidation {
    private TableRowValidation() {
    }

    static void validate(LogicalSchema schema, GenericKey key, GenericRow value) {
        int actualValueCount;
        int expectedKeyCount = schema.key().size();
        int actualKeyCount = key.values().size();
        if (actualKeyCount != expectedKeyCount) {
            throw new IllegalArgumentException("key column count mismatch. expected: " + expectedKeyCount + ", got: " + actualKeyCount);
        }
        int expectedValueCount = schema.value().size();
        if (expectedValueCount != (actualValueCount = value.size())) {
            throw new IllegalArgumentException("value column count mismatch. expected: " + expectedValueCount + ", got: " + actualValueCount);
        }
    }

    static interface Validator {
        public void validate(LogicalSchema var1, GenericKey var2, GenericRow var3);
    }
}

