/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.WindowedRow;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.execution.streams.materialization.ks.NotUpToBoundException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.StateQueryRequest;
import org.apache.kafka.streams.query.StateQueryResult;
import org.apache.kafka.streams.query.WindowRangeQuery;
import org.apache.kafka.streams.state.KeyValueIterator;

class KsMaterializedSessionTableIQv2
implements StreamsMaterializedWindowedTable {
    private final KsStateStore stateStore;

    KsMaterializedSessionTableIQv2(KsStateStore store) {
        this.stateStore = Objects.requireNonNull(store, "store");
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(GenericKey key, int partition, Range<Instant> windowStart, Range<Instant> windowEnd, Optional<Position> position) {
        KsMaterializedQueryResult<WindowedRow> ksMaterializedQueryResult;
        block12: {
            StateQueryResult result;
            QueryResult queryResult;
            WindowRangeQuery query = WindowRangeQuery.withKey((Object)key);
            StateQueryRequest request = StateQueryRequest.inStore((String)this.stateStore.getStateStoreName()).withQuery((Query)query);
            if (position.isPresent()) {
                request = request.withPositionBound(PositionBound.at((Position)position.get()));
            }
            if ((queryResult = (QueryResult)(result = this.stateStore.getKafkaStreams().query(request)).getPartitionResults().get(partition)).isFailure()) {
                throw this.failedQueryException(queryResult);
            }
            KeyValueIterator it = (KeyValueIterator)queryResult.getResult();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                while (it.hasNext()) {
                    KeyValue next = (KeyValue)it.next();
                    Window wnd = ((Windowed)next.key).window();
                    if (!windowStart.contains((Comparable)wnd.startTime()) || !windowEnd.contains((Comparable)wnd.endTime())) continue;
                    long rowTime = wnd.end();
                    WindowedRow row = WindowedRow.of(this.stateStore.schema(), (Windowed<GenericKey>)((Windowed)next.key), (GenericRow)next.value, rowTime);
                    builder.add((Object)row);
                }
                ksMaterializedQueryResult = KsMaterializedQueryResult.rowIteratorWithPosition(builder.build().iterator(), queryResult.getPosition());
                if (it == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MaterializationException | NotUpToBoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MaterializationException("Failed to get value from materialized table", e);
                }
            }
            it.close();
        }
        return ksMaterializedQueryResult;
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<Position> position) {
        throw new MaterializationException("Table scan unsupported on session tables");
    }

    private Exception failedQueryException(QueryResult<?> queryResult) {
        String message = "Failed to get value from materialized table: " + String.valueOf(queryResult.getFailureReason()) + ": " + queryResult.getFailureMessage();
        if (queryResult.getFailureReason().equals((Object)FailureReason.NOT_UP_TO_BOUND)) {
            return new NotUpToBoundException(message);
        }
        return new MaterializationException(message);
    }
}

