/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RocksDBMetricsCollector
implements MetricsReporter {
    private static final Logger LOGGER = LogManager.getLogger(RocksDBMetricsCollector.class);
    static final String KSQL_ROCKSDB_METRICS_GROUP = "ksql-rocksdb-aggregates";
    static final String NUMBER_OF_RUNNING_COMPACTIONS = "num-running-compactions";
    static final String BLOCK_CACHE_USAGE = "block-cache-usage";
    static final String BLOCK_CACHE_PINNED_USAGE = "block-cache-pinned-usage";
    static final String ESTIMATE_NUM_KEYS = "estimate-num-keys";
    static final String ESTIMATE_TABLE_READERS_MEM = "estimate-table-readers-mem";
    static final String NUMBER_OF_ENTRIES_ACTIVE_MEMTABLE = "num-entries-active-mem-table";
    static final String NUMBER_OF_DELETES_ACTIVE_MEMTABLE = "num-deletes-active-mem-table";
    static final String NUMBER_OF_ENTRIES_IMMUTABLE_MEMTABLES = "num-entries-imm-mem-tables";
    static final String NUMBER_OF_DELETES_IMMUTABLE_MEMTABLES = "num-deletes-imm-mem-tables";
    static final String NUMBER_OF_IMMUTABLE_MEMTABLES = "num-immutable-mem-table";
    static final String CURRENT_SIZE_OF_ACTIVE_MEMTABLE = "cur-size-active-mem-table";
    static final String CURRENT_SIZE_OF_ALL_MEMTABLES = "cur-size-all-mem-tables";
    static final String SIZE_OF_ALL_MEMTABLES = "size-all-mem-tables";
    static final String MEMTABLE_FLUSH_PENDING = "mem-table-flush-pending";
    static final String NUMBER_OF_RUNNING_FLUSHES = "num-running-flushes";
    static final String COMPACTION_PENDING = "compaction-pending";
    static final String ESTIMATED_BYTES_OF_PENDING_COMPACTION = "estimate-pending-compaction-bytes";
    static final String TOTAL_SST_FILES_SIZE = "total-sst-files-size";
    static final String LIVE_SST_FILES_SIZE = "live-sst-files-size";
    static final String UPDATE_INTERVAL_CONFIG = "ksql.rocksdb.metrics.update.interval.seconds";
    private static final int UPDATE_INTERVAL_DEFAULT = 15;
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("ksql.rocksdb.metrics.update.interval.seconds", ConfigDef.Type.INT, (Object)15, ConfigDef.Importance.LOW, "minimum interval between computations of a metric value");
    private static final Object lock = new Object();
    private static Map<String, Collection<AggregatedMetric<?>>> registeredMetrics = null;
    private Metrics metrics;

    public void configure(Map<String, ?> map) {
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, map);
        this.metrics = Objects.requireNonNull((Metrics)map.get("ksql.internal.metrics"));
        RocksDBMetricsCollector.configureShared(config, this.metrics);
    }

    public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    public void init(List<KafkaMetric> initial) {
        initial.forEach(this::metricChange);
    }

    public void metricChange(KafkaMetric metric) {
        if (!metric.metricName().group().equals("stream-state-metrics")) {
            return;
        }
        this.metricRemoval(metric);
        Collection<AggregatedMetric<?>> registered = registeredMetrics.get(metric.metricName().name());
        if (registered == null) {
            return;
        }
        registered.forEach(r -> r.add(metric));
    }

    public void metricRemoval(KafkaMetric metric) {
        MetricName metricName = metric.metricName();
        if (!metricName.group().equals("stream-state-metrics")) {
            return;
        }
        Collection<AggregatedMetric<?>> registered = registeredMetrics.get(metricName.name());
        if (registered == null) {
            return;
        }
        registered.forEach(r -> r.remove(metricName));
    }

    @VisibleForTesting
    static void reset() {
        registeredMetrics = null;
    }

    public void close() {
    }

    public static void update() {
        registeredMetrics.values().stream().flatMap(Collection::stream).forEach(AggregatedMetric::update);
    }

    private static void registerBigIntTotal(int interval, Map<String, Collection<AggregatedMetric<?>>> registeredMetrics, String name, Metrics metrics) {
        registeredMetrics.putIfAbsent(name, new LinkedList());
        AggregatedMetric<BigInteger> registered = new AggregatedMetric<BigInteger>(BigInteger.class, BigInteger::add, BigInteger.ZERO, new Interval(interval));
        registeredMetrics.get(name).add(registered);
        MetricName metricName = metrics.metricName(name + "-total", KSQL_ROCKSDB_METRICS_GROUP);
        metrics.addMetric(metricName, (MetricValueProvider)((Gauge)(c, t) -> (BigInteger)registered.getValue()));
    }

    private static void registerBigIntMax(int interval, Map<String, Collection<AggregatedMetric<?>>> registeredMetrics, String name, Metrics metrics) {
        registeredMetrics.putIfAbsent(name, new LinkedList());
        AggregatedMetric<BigInteger> registered = new AggregatedMetric<BigInteger>(BigInteger.class, BigInteger::max, BigInteger.ZERO, new Interval(interval));
        registeredMetrics.get(name).add(registered);
        MetricName metricName = metrics.metricName(name + "-max", KSQL_ROCKSDB_METRICS_GROUP);
        metrics.addMetric(metricName, (MetricValueProvider)((Gauge)(c, t) -> (BigInteger)registered.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureShared(AbstractConfig config, Metrics metrics) {
        Object object = lock;
        synchronized (object) {
            if (registeredMetrics != null) {
                return;
            }
            int interval = config.getInt(UPDATE_INTERVAL_CONFIG);
            HashMap builder = new HashMap();
            RocksDBMetricsCollector.registerAll(interval, builder, metrics);
            registeredMetrics = ImmutableMap.copyOf(builder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ImmutableList.copyOf((Collection)((Collection)e.getValue())))));
        }
    }

    private static void registerAll(int interval, Map<String, Collection<AggregatedMetric<?>>> builder, Metrics metrics) {
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_RUNNING_COMPACTIONS, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, BLOCK_CACHE_USAGE, metrics);
        RocksDBMetricsCollector.registerBigIntMax(interval, builder, BLOCK_CACHE_USAGE, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, BLOCK_CACHE_PINNED_USAGE, metrics);
        RocksDBMetricsCollector.registerBigIntMax(interval, builder, BLOCK_CACHE_PINNED_USAGE, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, ESTIMATE_NUM_KEYS, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, ESTIMATE_TABLE_READERS_MEM, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_ENTRIES_ACTIVE_MEMTABLE, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_ENTRIES_IMMUTABLE_MEMTABLES, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_DELETES_ACTIVE_MEMTABLE, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_DELETES_IMMUTABLE_MEMTABLES, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_IMMUTABLE_MEMTABLES, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, CURRENT_SIZE_OF_ACTIVE_MEMTABLE, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, CURRENT_SIZE_OF_ALL_MEMTABLES, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, SIZE_OF_ALL_MEMTABLES, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, MEMTABLE_FLUSH_PENDING, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, NUMBER_OF_RUNNING_FLUSHES, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, COMPACTION_PENDING, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, ESTIMATED_BYTES_OF_PENDING_COMPACTION, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, TOTAL_SST_FILES_SIZE, metrics);
        RocksDBMetricsCollector.registerBigIntTotal(interval, builder, LIVE_SST_FILES_SIZE, metrics);
    }

    static final class AggregatedMetric<T> {
        private final Class<T> clazz;
        private final BinaryOperator<T> aggregator;
        private final T identity;
        private final Interval interval;
        private final Map<MetricName, KafkaMetric> metrics = new ConcurrentHashMap<MetricName, KafkaMetric>();
        private volatile T value;

        private AggregatedMetric(Class<T> clazz, BinaryOperator<T> aggregator, T identity, Interval interval) {
            this.clazz = Objects.requireNonNull(clazz, "clazz");
            this.aggregator = Objects.requireNonNull(aggregator, "aggregator");
            this.identity = Objects.requireNonNull(identity, "identity");
            this.value = identity;
            this.interval = interval;
        }

        private void add(KafkaMetric metric) {
            this.metrics.put(metric.metricName(), metric);
        }

        private void remove(MetricName name) {
            this.metrics.remove(name);
        }

        private T getValue() {
            if (this.interval.check()) {
                this.value = this.update();
            }
            return this.value;
        }

        private T update() {
            Object current = this.identity;
            for (KafkaMetric metric : this.metrics.values()) {
                Object value = metric.metricValue();
                if (!this.clazz.isInstance(value)) {
                    LOGGER.debug("Skipping metric update due to unexpected value type returned by {}", (Object)metric.metricName().toString());
                    return this.identity;
                }
                current = this.aggregator.apply(current, this.clazz.cast(value));
            }
            return current;
        }
    }

    static final class Interval {
        private final int intervalSeconds;
        private final AtomicReference<Instant> last;
        private final Supplier<Instant> clock;

        private Interval(int intervalSeconds) {
            this(intervalSeconds, Instant::now);
        }

        Interval(int intervalSeconds, Supplier<Instant> clock) {
            this.intervalSeconds = intervalSeconds;
            this.clock = Objects.requireNonNull(clock, "clock");
            this.last = new AtomicReference<Instant>(Instant.EPOCH);
        }

        boolean check() {
            Instant now = this.clock.get();
            Instant previous = this.last.getAndAccumulate(now, (l, n) -> n.isAfter(l.plusSeconds(this.intervalSeconds)) ? n : l);
            return this.last.get().isAfter(previous);
        }
    }
}

