/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.process;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import java.util.Objects;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorContext;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

public class KsFlatTransformedValueProcessor<K, R>
implements FixedKeyProcessor<K, GenericRow, R> {
    private final KsqlTransformer<K, Iterable<R>> delegate;
    private FixedKeyProcessorContext<K, R> processorContext;

    public KsFlatTransformedValueProcessor(KsqlTransformer<K, Iterable<R>> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.processorContext = null;
    }

    public void init(FixedKeyProcessorContext<K, R> context) {
        this.processorContext = context;
    }

    public void process(FixedKeyRecord<K, GenericRow> record) {
        Object key = record.key();
        GenericRow value = (GenericRow)record.value();
        if (value == null) {
            return;
        }
        Iterable result = (Iterable)this.delegate.transform(key, value);
        if (result == null) {
            return;
        }
        result.forEach(r -> this.processorContext.forward(record.withValue(r)));
    }
}

