/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.timestamp;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.streams.timestamp.KsqlTimestampExtractor;
import io.confluent.ksql.execution.streams.timestamp.LongTimestampExtractor;
import io.confluent.ksql.execution.streams.timestamp.TimestampColumnExtractors;
import io.confluent.ksql.execution.streams.timestamp.TimestampExtractionPolicy;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class LongColumnTimestampExtractionPolicy
implements TimestampExtractionPolicy {
    private final ColumnName timestampField;

    public LongColumnTimestampExtractionPolicy(ColumnName timestampField) {
        Objects.requireNonNull(timestampField, "timestampField can't be null");
        this.timestampField = timestampField;
    }

    @Override
    public KsqlTimestampExtractor create(Optional<Column> tsColumn) {
        Column column = tsColumn.orElseThrow(IllegalArgumentException::new);
        return new LongTimestampExtractor(TimestampColumnExtractors.create(column));
    }

    @Override
    public ColumnName getTimestampField() {
        return this.timestampField;
    }

    public int hashCode() {
        return Objects.hash(this.timestampField);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LongColumnTimestampExtractionPolicy)) {
            return false;
        }
        LongColumnTimestampExtractionPolicy otherPolicy = (LongColumnTimestampExtractionPolicy)other;
        return Objects.equals(otherPolicy.timestampField, this.timestampField);
    }
}

