/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.timestamp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.streams.timestamp.KsqlTimestampExtractor;
import io.confluent.ksql.execution.streams.timestamp.StringTimestampExtractor;
import io.confluent.ksql.execution.streams.timestamp.TimestampColumnExtractors;
import io.confluent.ksql.execution.streams.timestamp.TimestampExtractionPolicy;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class StringTimestampExtractionPolicy
implements TimestampExtractionPolicy {
    private final ColumnName timestampField;
    @JsonProperty(value="format")
    private final String format;

    public StringTimestampExtractionPolicy(@JsonProperty(value="timestampField", required=true) ColumnName timestampField, @JsonProperty(value="format", required=true) String format) {
        Objects.requireNonNull(timestampField, "timestampField can't be null");
        Objects.requireNonNull(format, "format can't be null");
        this.timestampField = timestampField;
        this.format = format;
    }

    @Override
    public KsqlTimestampExtractor create(Optional<Column> tsColumn) {
        Column column = tsColumn.orElseThrow(IllegalArgumentException::new);
        return new StringTimestampExtractor(this.format, TimestampColumnExtractors.create(column));
    }

    @Override
    public ColumnName getTimestampField() {
        return this.timestampField;
    }

    public int hashCode() {
        return Objects.hash(this.timestampField, this.format);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringTimestampExtractionPolicy)) {
            return false;
        }
        StringTimestampExtractionPolicy otherPolicy = (StringTimestampExtractionPolicy)other;
        return Objects.equals(otherPolicy.timestampField, this.timestampField) && Objects.equals(otherPolicy.format, this.format);
    }
}

