/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.timestamp;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.timestamp.ColumnExtractor;
import io.confluent.ksql.execution.streams.timestamp.KsqlTimestampExtractor;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.timestamp.StringToTimestampParser;
import java.util.Objects;

public class StringTimestampExtractor
implements KsqlTimestampExtractor {
    private final StringToTimestampParser timestampParser;
    private final ColumnExtractor extractor;
    private final String format;

    StringTimestampExtractor(String format, ColumnExtractor extractor) {
        this.format = Objects.requireNonNull(format, "format can't be null");
        this.extractor = Objects.requireNonNull(extractor, "extractor");
        this.timestampParser = new StringToTimestampParser(format);
    }

    @Override
    public long extract(Object key, GenericRow value) {
        String colValue = (String)this.extractor.extract(key, value);
        try {
            return this.timestampParser.parse(colValue);
        }
        catch (KsqlException e) {
            throw new KsqlException("Unable to parse string timestamp. timestamp=" + String.valueOf(value) + " timestamp_format=" + this.format, (Throwable)e);
        }
    }
}

