/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.database;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.api.database.DatabaseRoleOptions;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.response.DatabaseResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class Database
extends OperationsBase {
    private final String mountPath;
    private String nameSpace;

    public Database withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public Database(VaultConfig config) {
        this(config, "database");
    }

    public Database(VaultConfig config, String mountPath) {
        super(config);
        this.mountPath = mountPath;
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public DatabaseResponse createOrUpdateRole(String roleName, DatabaseRoleOptions options) throws VaultException {
        return this.retry(attempt -> {
            String requestJson = this.roleOptionsToJson(options);
            RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new DatabaseResponse(restResponse, attempt);
        });
    }

    public DatabaseResponse getRole(String roleName) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new DatabaseResponse(restResponse, attempt);
        });
    }

    public DatabaseResponse revoke(String serialNumber) throws VaultException {
        return this.retry(attempt -> {
            JsonObject jsonObject = new JsonObject();
            if (serialNumber != null) {
                jsonObject.add("serial_number", serialNumber);
            }
            String requestJson = jsonObject.toString();
            RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/revoke", this.config.getAddress(), this.mountPath)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).body(requestJson.getBytes(StandardCharsets.UTF_8)).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new DatabaseResponse(restResponse, attempt);
        });
    }

    public DatabaseResponse deleteRole(String roleName) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new DatabaseResponse(restResponse, attempt);
        });
    }

    public DatabaseResponse creds(String roleName) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/creds/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
            }
            return new DatabaseResponse(restResponse, attempt);
        });
    }

    private String roleOptionsToJson(DatabaseRoleOptions options) {
        JsonObject jsonObject = Json.object();
        if (options != null) {
            this.addJsonFieldIfNotNull(jsonObject, "db_name", options.getDbName());
            this.addJsonFieldIfNotNull(jsonObject, "default_ttl", options.getDefaultTtl());
            this.addJsonFieldIfNotNull(jsonObject, "max_ttl", options.getMaxTtl());
            this.addJsonFieldIfNotNull(jsonObject, "creation_statements", this.joinList(options.getCreationStatements()));
            this.addJsonFieldIfNotNull(jsonObject, "revocation_statements", this.joinList(options.getRevocationStatements()));
            this.addJsonFieldIfNotNull(jsonObject, "rollback_statements", this.joinList(options.getRollbackStatements()));
            this.addJsonFieldIfNotNull(jsonObject, "renew_statements", this.joinList(options.getRenewStatements()));
        }
        return jsonObject.toString();
    }

    private String joinList(List<String> data) {
        String result = "";
        if (data != null && !data.isEmpty()) {
            result = String.join((CharSequence)",", data);
        }
        return result;
    }

    private JsonObject addJsonFieldIfNotNull(JsonObject jsonObject, String name, Object value) {
        if (value == null) {
            return jsonObject;
        }
        if (value instanceof String) {
            jsonObject.add(name, (String)value);
        } else if (value instanceof Boolean) {
            jsonObject.add(name, (Boolean)value);
        } else if (value instanceof Long) {
            jsonObject.add(name, (Long)value);
        }
        return jsonObject;
    }
}

