/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.sys.mounts;

import io.github.jopenlibs.vault.api.sys.mounts.MountType;
import io.github.jopenlibs.vault.api.sys.mounts.TimeToLive;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MountPayload
implements Serializable {
    private static final long serialVersionUID = 839595627039704093L;
    private TimeToLive defaultLeaseTtl;
    private TimeToLive maxLeaseTtl;
    private String description;
    private Boolean forceNoCache;
    private String pluginName;
    private Boolean local;
    private Boolean sealWrap;
    private List<String> auditNonHmacRequestKeys;
    private List<String> auditNonHmacResponseKeys;

    public MountPayload defaultLeaseTtl(TimeToLive defaultLeaseTtl) {
        this.defaultLeaseTtl = defaultLeaseTtl;
        return this;
    }

    public MountPayload maxLeaseTtl(TimeToLive maxLeaseTtl) {
        this.maxLeaseTtl = maxLeaseTtl;
        return this;
    }

    public MountPayload description(String description) {
        this.description = description;
        return this;
    }

    public MountPayload forceNoCache(Boolean forceNoCache) {
        this.forceNoCache = forceNoCache;
        return this;
    }

    public MountPayload pluginName(String pluginName) {
        this.pluginName = pluginName;
        return this;
    }

    public MountPayload local(Boolean local) {
        this.local = local;
        return this;
    }

    public MountPayload sealWrap(Boolean sealWrap) {
        this.sealWrap = sealWrap;
        return this;
    }

    public MountPayload auditNonHmacRequestKeys(List<String> auditNonHmacRequestKeys) {
        if (auditNonHmacRequestKeys != null) {
            this.auditNonHmacRequestKeys = new ArrayList<String>();
            this.auditNonHmacRequestKeys.addAll(auditNonHmacRequestKeys);
        }
        return this;
    }

    public MountPayload auditNonHmacResponseKeys(List<String> auditNonHmacResponseKeys) {
        if (auditNonHmacResponseKeys != null) {
            this.auditNonHmacResponseKeys = new ArrayList<String>();
            this.auditNonHmacResponseKeys.addAll(auditNonHmacResponseKeys);
        }
        return this;
    }

    public List<String> getAuditNonHmacRequestKeys() {
        if (this.auditNonHmacRequestKeys == null) {
            return null;
        }
        return new ArrayList<String>(this.auditNonHmacRequestKeys);
    }

    public List<String> getAuditNonHmacResponseKeys() {
        if (this.auditNonHmacResponseKeys == null) {
            return null;
        }
        return new ArrayList<String>(this.auditNonHmacResponseKeys);
    }

    public JsonObject toEnableJson(MountType type) {
        JsonObject jsonObject = Json.object();
        jsonObject.addIfNotNull("type", type.value());
        jsonObject.addIfNotNull("description", this.description);
        jsonObject.addIfNotNull("config", this.toConfigJson());
        jsonObject.addIfNotNull("plugin_name", this.pluginName);
        jsonObject.addIfNotNull("local", this.local);
        jsonObject.addIfNotNull("seal_wrap", this.sealWrap);
        return jsonObject;
    }

    public JsonObject toTuneJson() {
        JsonObject jsonObject = Json.object();
        if (this.defaultLeaseTtl != null) {
            jsonObject.addIfNotNull("default_lease_ttl", this.defaultLeaseTtl.toString());
        }
        if (this.maxLeaseTtl != null) {
            jsonObject.addIfNotNull("max_lease_ttl", this.maxLeaseTtl.toString());
        }
        jsonObject.addIfNotNull("description", this.description);
        if (this.auditNonHmacRequestKeys != null && this.auditNonHmacRequestKeys.size() > 0) {
            jsonObject.addIfNotNull("audit_non_hmac_request_keys", String.join((CharSequence)",", this.auditNonHmacRequestKeys));
        }
        if (this.auditNonHmacResponseKeys != null && this.auditNonHmacResponseKeys.size() > 0) {
            jsonObject.addIfNotNull("audit_non_hmac_response_keys", String.join((CharSequence)",", this.auditNonHmacResponseKeys));
        }
        return jsonObject;
    }

    private JsonObject toConfigJson() {
        JsonObject jsonObject = this.toTuneJson();
        jsonObject.addIfNotNull("force_no_cache", this.forceNoCache);
        jsonObject.addIfNotNull("plugin_name", this.pluginName);
        if (jsonObject.isEmpty()) {
            return null;
        }
        return jsonObject;
    }

    public TimeToLive getDefaultLeaseTtl() {
        return this.defaultLeaseTtl;
    }

    public TimeToLive getMaxLeaseTtl() {
        return this.maxLeaseTtl;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getForceNoCache() {
        return this.forceNoCache;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Boolean getLocal() {
        return this.local;
    }

    public Boolean getSealWrap() {
        return this.sealWrap;
    }
}

