/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.response;

import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonArray;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.json.ParseException;
import io.github.jopenlibs.vault.response.VaultResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class LookupResponse
extends VaultResponse {
    private String accessor;
    private long creationTime;
    private long creationTTL;
    private String displayName;
    private long explicitMaxTTL;
    private String id;
    private Long lastRenewalTime;
    private int numUses;
    private boolean orphan;
    private String path;
    private List<String> policies;
    private boolean renewable;
    private long ttl;
    private String username;

    public LookupResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries);
        try {
            String responseJson = new String(restResponse.getBody(), StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(responseJson).asObject();
            JsonObject dataJsonObject = jsonObject.get("data").asObject();
            this.accessor = dataJsonObject.getString("accessor", "");
            this.creationTime = dataJsonObject.getLong("creation_time", 0L);
            this.creationTTL = dataJsonObject.getLong("creation_ttl", 0L);
            this.displayName = dataJsonObject.getString("display_name", "");
            this.explicitMaxTTL = dataJsonObject.getLong("explicit_max_ttl", 0L);
            this.id = dataJsonObject.getString("id", "");
            JsonValue lastRenewalTimeJsonValue = dataJsonObject.get("last_renewal_time");
            if (lastRenewalTimeJsonValue != null) {
                this.lastRenewalTime = lastRenewalTimeJsonValue.asLong();
            }
            if (dataJsonObject.get("metadata") != null && !dataJsonObject.get("metadata").toString().equalsIgnoreCase("null")) {
                JsonObject metadata = dataJsonObject.get("metadata").asObject();
                this.username = metadata.getString("username", "");
            }
            this.numUses = dataJsonObject.getInt("num_uses", 0);
            this.orphan = dataJsonObject.getBoolean("orphan", true);
            this.path = dataJsonObject.getString("path", "");
            JsonArray policiesJsonArray = dataJsonObject.get("policies").asArray();
            this.policies = new ArrayList<String>();
            for (JsonValue policy : policiesJsonArray) {
                this.policies.add(policy.asString());
            }
            this.renewable = dataJsonObject.getBoolean("renewable", false);
            this.ttl = dataJsonObject.getLong("ttl", 0L);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getAccessor() {
        return this.accessor;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getCreationTTL() {
        return this.creationTTL;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getExplicitMaxTTL() {
        return this.explicitMaxTTL;
    }

    public String getId() {
        return this.id;
    }

    public Long getLastRenewalTime() {
        return this.lastRenewalTime;
    }

    public int getNumUses() {
        return this.numUses;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public long getTTL() {
        return this.ttl;
    }

    public String getUsername() {
        return this.username;
    }
}

