/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.gcpkms;

import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudkms.v1.model.DecryptRequest;
import com.google.api.services.cloudkms.v1.model.DecryptResponse;
import com.google.api.services.cloudkms.v1.model.EncryptRequest;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.crypto.tink.Aead;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class GcpKmsAead
implements Aead {
    private final CloudKMS kmsClient;
    private final String keyName;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public GcpKmsAead(CloudKMS kmsClient, String keyName) {
        this.kmsClient = kmsClient;
        this.keyName = keyName;
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        try {
            EncryptRequest request = new EncryptRequest().encodePlaintext(plaintext).encodeAdditionalAuthenticatedData(associatedData);
            com.google.api.services.cloudkms.v1.model.EncryptResponse response = (com.google.api.services.cloudkms.v1.model.EncryptResponse)this.kmsClient.projects().locations().keyRings().cryptoKeys().encrypt(this.keyName, request).execute();
            return GcpKmsAead.toNonNullableByteArray(response.decodeCiphertext());
        }
        catch (IOException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            DecryptRequest request = new DecryptRequest().encodeCiphertext(ciphertext).encodeAdditionalAuthenticatedData(associatedData);
            DecryptResponse response = (DecryptResponse)this.kmsClient.projects().locations().keyRings().cryptoKeys().decrypt(this.keyName, request).execute();
            return GcpKmsAead.toNonNullableByteArray(response.decodePlaintext());
        }
        catch (IOException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }

    private static byte[] toNonNullableByteArray(byte[] data) {
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String keyName = null;
        @Nullable
        private CloudKMS kmsClientHttp = null;
        @Nullable
        private KeyManagementServiceClient kmsClientGrpc = null;
        private static final String KEY_NAME_PATTERN = "projects/([^/]+)/locations/([a-zA-Z0-9_-]{1,63})/keyRings/[a-zA-Z0-9_-]{1,63}/cryptoKeys/[a-zA-Z0-9_-]{1,63}";
        private static final Pattern KEY_NAME_MATCHER = Pattern.compile("projects/([^/]+)/locations/([a-zA-Z0-9_-]{1,63})/keyRings/[a-zA-Z0-9_-]{1,63}/cryptoKeys/[a-zA-Z0-9_-]{1,63}");

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCloudKms(CloudKMS cloudKms) {
            this.kmsClientHttp = cloudKms;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setKeyManagementServiceClient(KeyManagementServiceClient kmsClient) {
            this.kmsClientGrpc = kmsClient;
            return this;
        }

        public Aead build() throws GeneralSecurityException {
            if (this.keyName == null) {
                throw new GeneralSecurityException("The keyName is null.");
            }
            if (this.keyName.isEmpty()) {
                throw new GeneralSecurityException("The keyName is empty.");
            }
            if (!KEY_NAME_MATCHER.matcher(this.keyName).matches()) {
                throw new GeneralSecurityException("The keyName must follow projects/([^/]+)/locations/([a-zA-Z0-9_-]{1,63})/keyRings/[a-zA-Z0-9_-]{1,63}/cryptoKeys/[a-zA-Z0-9_-]{1,63}");
            }
            if (this.kmsClientGrpc == null && this.kmsClientHttp == null) {
                throw new GeneralSecurityException("Either the CloudKMS or the KeyManagementServiceClient object must be provided.");
            }
            if (this.kmsClientGrpc != null && this.kmsClientHttp != null) {
                throw new GeneralSecurityException("Either the CloudKMS or the KeyManagementServiceClient object must be provided.");
            }
            if (this.kmsClientHttp != null) {
                return new GcpKmsAead(this.kmsClientHttp, this.keyName);
            }
            return new GcpKmsAeadGrpc(this.kmsClientGrpc, this.keyName);
        }
    }

    private static final class GcpKmsAeadGrpc
    implements Aead {
        private final KeyManagementServiceClient kmsClient;
        private final String keyName;

        private GcpKmsAeadGrpc(KeyManagementServiceClient kmsClient, String keyName) {
            this.kmsClient = kmsClient;
            this.keyName = keyName;
        }

        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            try {
                com.google.cloud.kms.v1.EncryptRequest encryptRequest = com.google.cloud.kms.v1.EncryptRequest.newBuilder().setName(this.keyName).setPlaintext(ByteString.copyFrom((byte[])plaintext)).setAdditionalAuthenticatedData(ByteString.copyFrom((byte[])associatedData)).build();
                EncryptResponse encResponse = this.kmsClient.encrypt(encryptRequest);
                return encResponse.getCiphertext().toByteArray();
            }
            catch (RuntimeException e) {
                throw new GeneralSecurityException("encryption failed", e);
            }
        }

        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            try {
                com.google.cloud.kms.v1.DecryptRequest decryptRequest = com.google.cloud.kms.v1.DecryptRequest.newBuilder().setName(this.keyName).setCiphertext(ByteString.copyFrom((byte[])ciphertext)).setAdditionalAuthenticatedData(ByteString.copyFrom((byte[])associatedData)).build();
                com.google.cloud.kms.v1.DecryptResponse decResponse = this.kmsClient.decrypt(decryptRequest);
                return decResponse.getPlaintext().toByteArray();
            }
            catch (RuntimeException e) {
                throw new GeneralSecurityException("decryption failed", e);
            }
        }
    }
}

