/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.execution.pull.HARouting;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.ConfiguredKsqlPlan;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.StreamPullQueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import io.vertx.core.Context;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public interface KsqlExecutionContext {
    public KsqlExecutionContext createSandbox(ServiceContext var1);

    public MetaStore getMetaStore();

    public KsqlConfig getKsqlConfig();

    public MetricCollectors metricCollectors();

    public void alterSystemProperty(String var1, String var2);

    public void updateStreamsPropertiesAndRestartRuntime();

    public ServiceContext getServiceContext();

    public ProcessingLogContext getProcessingLogContext();

    public Optional<PersistentQueryMetadata> getPersistentQuery(QueryId var1);

    public Optional<QueryMetadata> getQuery(QueryId var1);

    public List<PersistentQueryMetadata> getPersistentQueries();

    public Set<QueryId> getQueriesWithSink(SourceName var1);

    public List<QueryMetadata> getAllLiveQueries();

    public List<KsqlParser.ParsedStatement> parse(String var1);

    public KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement var1, Map<String, String> var2);

    default public KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement stmt) {
        return this.prepare(stmt, Collections.emptyMap());
    }

    public TransientQueryMetadata executeTransientQuery(ServiceContext var1, ConfiguredStatement<Query> var2, boolean var3);

    public PullQueryResult executeTablePullQuery(ImmutableAnalysis var1, ServiceContext var2, ConfiguredStatement<Query> var3, HARouting var4, RoutingOptions var5, QueryPlannerOptions var6, Optional<PullQueryExecutorMetrics> var7, boolean var8, Optional<ConsistencyOffsetVector> var9);

    public ScalablePushQueryMetadata executeScalablePushQuery(ImmutableAnalysis var1, ServiceContext var2, ConfiguredStatement<Query> var3, PushRouting var4, PushRoutingOptions var5, QueryPlannerOptions var6, Context var7, Optional<ScalablePushQueryMetrics> var8);

    public ImmutableAnalysis analyzeQueryWithNoOutputTopic(Query var1, String var2, Map<String, Object> var3);

    public StreamPullQueryMetadata createStreamPullQuery(ServiceContext var1, ImmutableAnalysis var2, ConfiguredStatement<Query> var3, boolean var4);

    public KsqlPlan plan(ServiceContext var1, ConfiguredStatement<?> var2);

    default public ExecuteResult execute(ServiceContext serviceContext, ConfiguredKsqlPlan plan) {
        return this.execute(serviceContext, plan, false);
    }

    public ExecuteResult execute(ServiceContext var1, ConfiguredKsqlPlan var2, boolean var3);

    public ExecuteResult execute(ServiceContext var1, ConfiguredStatement<?> var2);

    public static final class ExecuteResult {
        private final Optional<QueryMetadata> query;
        private final Optional<String> commandResult;

        public static ExecuteResult of(QueryMetadata query) {
            return new ExecuteResult(Optional.of(query), Optional.empty());
        }

        public static ExecuteResult of(String commandResult) {
            return new ExecuteResult(Optional.empty(), Optional.of(commandResult));
        }

        public Optional<QueryMetadata> getQuery() {
            return this.query;
        }

        public Optional<String> getCommandResult() {
            return this.commandResult;
        }

        private ExecuteResult(Optional<QueryMetadata> query, Optional<String> commandResult) {
            this.query = Objects.requireNonNull(query, "query");
            this.commandResult = Objects.requireNonNull(commandResult, "commandResult");
        }
    }
}

