/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.engine.rewrite.StatementRewriteForMagicPseudoTimestamp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.Objects;

public final class FilterTypeValidator {
    private final LogicalSchema schema;
    private final FunctionRegistry functionRegistry;
    private final FilterType filterType;

    public FilterTypeValidator(LogicalSchema schema, FunctionRegistry functionRegistry, FilterType filterType) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.filterType = Objects.requireNonNull(filterType, "filterType");
    }

    public void validateFilterExpression(Expression exp) {
        SqlType type = this.getExpressionReturnType(exp);
        if (!SqlTypes.BOOLEAN.equals((Object)type)) {
            throw new KsqlStatementException("Type error in " + this.filterType.name() + " expression: Should evaluate to boolean but is (" + type.toString(FormatOptions.none()) + ") instead.", "Type error in " + this.filterType.name() + " expression: Should evaluate to boolean but is " + exp.toString() + " (" + type.toString(FormatOptions.none()) + ") instead.", exp.toString());
        }
    }

    private SqlType getExpressionReturnType(Expression exp) {
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(this.schema, this.functionRegistry);
        Expression magicTimestampRewrite = new StatementRewriteForMagicPseudoTimestamp().rewrite(exp);
        try {
            return expressionTypeManager.getExpressionSqlType(magicTimestampRewrite);
        }
        catch (KsqlStatementException e) {
            throw new KsqlStatementException("Error in " + this.filterType.name() + " expression", "Error in " + this.filterType.name() + " expression: " + e.getUnloggedMessage(), exp.toString());
        }
        catch (KsqlException e) {
            throw new KsqlStatementException("Error in " + this.filterType.name() + " expression", "Error in " + this.filterType.name() + " expression: " + e.getMessage(), exp.toString());
        }
    }

    public static enum FilterType {
        WHERE,
        HAVING;

    }
}

