/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.Analyzer;
import io.confluent.ksql.analyzer.PullQueryValidator;
import io.confluent.ksql.analyzer.PushQueryValidator;
import io.confluent.ksql.analyzer.QueryValidator;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;

public class QueryAnalyzer {
    private final Analyzer analyzer;
    private final QueryValidator pullQueryValidator;
    private final QueryValidator pushQueryValidator;

    public QueryAnalyzer(MetaStore metaStore, String outputTopicPrefix, boolean pullLimitClauseEnabled) {
        this(new Analyzer(metaStore, outputTopicPrefix, pullLimitClauseEnabled), new PullQueryValidator(), new PushQueryValidator());
    }

    @VisibleForTesting
    QueryAnalyzer(Analyzer analyzer, QueryValidator pullQueryValidator, QueryValidator pushQueryValidator) {
        this.analyzer = Objects.requireNonNull(analyzer, "analyzer");
        this.pullQueryValidator = Objects.requireNonNull(pullQueryValidator, "pullQueryValidator");
        this.pushQueryValidator = Objects.requireNonNull(pushQueryValidator, "pushQueryValidator");
    }

    public Analysis analyze(Query query, Optional<Sink> sink) {
        Analysis.AliasedDataSource ds;
        Analysis analysis = this.analyzer.analyze(query, sink);
        if (query.isPullQuery()) {
            this.pullQueryValidator.validate(analysis);
        } else {
            this.pushQueryValidator.validate(analysis);
        }
        if (!analysis.getTableFunctions().isEmpty() && (ds = analysis.getFrom()).getDataSource().getDataSourceType() == DataSource.DataSourceType.KTABLE) {
            throw new KsqlException("Table source is not supported with table functions");
        }
        return analysis;
    }
}

