/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.stream.Collectors;

public final class QueryValidatorUtil {
    private QueryValidatorUtil() {
    }

    static void validateNoUserColumnsWithSameNameAsPseudoColumns(Analysis analysis) {
        String disallowedNames = analysis.getAllDataSources().stream().map(Analysis.AliasedDataSource::getDataSource).map(DataSource::getSchema).map(LogicalSchema::value).flatMap(Collection::stream).map(Column::name).filter(name -> SystemColumns.isPseudoColumn((ColumnName)name)).map(Name::toString).collect(Collectors.joining(", "));
        if (disallowedNames.length() > 0) {
            throw new KsqlException("Your stream/table has columns with the same name as newly introduced pseudocolumns in ksqlDB, and cannot be queried as a result. The conflicting names are: " + disallowedNames + ".\n");
        }
    }
}

