/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.ddl.commands.AlterSourceCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.tree.AlterSource;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AlterSourceFactory {
    private final MetaStore metaStore;

    @VisibleForTesting
    public AlterSourceFactory(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public AlterSourceCommand create(AlterSource statement) {
        DataSource dataSource = this.metaStore.getSource(statement.getName());
        String dataSourceType = statement.getDataSourceType().getKsqlType();
        if (dataSource != null && dataSource.isSource()) {
            throw new KsqlException(String.format("Cannot alter %s '%s': ALTER operations are not supported on source %s.", dataSourceType.toLowerCase(), statement.getName().text(), dataSourceType.toLowerCase() + "s"));
        }
        List newColumns = statement.getAlterOptions().stream().map(alterOption -> Column.of((ColumnName)ColumnName.of((String)alterOption.getColumnName()), (SqlType)alterOption.getType().getSqlType(), (Column.Namespace)Column.Namespace.VALUE, (int)0)).collect(Collectors.toList());
        return new AlterSourceCommand(statement.getName(), dataSourceType, newColumns);
    }
}

