/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.embedded;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.ServiceInfo;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.InternalFunctionRegistry;
import io.confluent.ksql.function.UserFunctionLoader;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.properties.PropertyOverrider;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.id.SequentialQueryIdGenerator;
import io.confluent.ksql.services.DisabledKsqlClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.ServiceContextFactory;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.statement.Injectors;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KsqlContext
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(KsqlContext.class);
    private final ServiceContext serviceContext;
    private final KsqlConfig ksqlConfig;
    private final KsqlEngine ksqlEngine;
    private final BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory;

    public static KsqlContext create(KsqlConfig ksqlConfig, ProcessingLogContext processingLogContext, MetricCollectors metricCollectors) {
        Objects.requireNonNull(ksqlConfig, "ksqlConfig cannot be null.");
        ServiceContext serviceContext = ServiceContextFactory.create(ksqlConfig, DisabledKsqlClient::instance);
        InternalFunctionRegistry functionRegistry = new InternalFunctionRegistry();
        UserFunctionLoader.newInstance(ksqlConfig, functionRegistry, ".", metricCollectors.getMetrics()).load();
        ServiceInfo serviceInfo = ServiceInfo.create(ksqlConfig);
        KsqlEngine engine = new KsqlEngine(serviceContext, processingLogContext, (FunctionRegistry)functionRegistry, serviceInfo, new SequentialQueryIdGenerator(), ksqlConfig, Collections.emptyList(), metricCollectors);
        return new KsqlContext(serviceContext, ksqlConfig, engine, Injectors.DEFAULT);
    }

    @VisibleForTesting
    KsqlContext(ServiceContext serviceContext, KsqlConfig ksqlConfig, KsqlEngine ksqlEngine, BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory) {
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.injectorFactory = Objects.requireNonNull(injectorFactory, "injectorFactory");
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public MetaStore getMetaStore() {
        return this.ksqlEngine.getMetaStore();
    }

    public List<QueryMetadata> sql(String sql) {
        return this.sql(sql, Collections.emptyMap());
    }

    public List<QueryMetadata> sql(String sql, Map<String, ?> overriddenProperties) {
        List<KsqlParser.ParsedStatement> statements = this.ksqlEngine.parse(sql);
        KsqlExecutionContext sandbox = this.ksqlEngine.createSandbox(this.ksqlEngine.getServiceContext());
        HashMap<String, Object> validationOverrides = new HashMap<String, Object>(overriddenProperties);
        for (KsqlParser.ParsedStatement stmt : statements) {
            KsqlContext.execute(sandbox, stmt, this.ksqlConfig, validationOverrides, this.injectorFactory.apply(sandbox, sandbox.getServiceContext()));
        }
        ArrayList<QueryMetadata> queries = new ArrayList<QueryMetadata>();
        Injector injector = this.injectorFactory.apply(this.ksqlEngine, this.serviceContext);
        HashMap<String, Object> executionOverrides = new HashMap<String, Object>(overriddenProperties);
        for (KsqlParser.ParsedStatement parsed : statements) {
            KsqlContext.execute(this.ksqlEngine, parsed, this.ksqlConfig, executionOverrides, injector).getQuery().ifPresent(queries::add);
        }
        for (QueryMetadata queryMetadata : queries) {
            if (queryMetadata instanceof PersistentQueryMetadata) {
                queryMetadata.start();
                continue;
            }
            QueryLogger.warn((Object)"Ignoring statement", sql);
            LOG.warn("Only CREATE statements can run in KSQL embedded mode.");
        }
        return queries;
    }

    @Deprecated
    public Set<QueryMetadata> getRunningQueries() {
        return new HashSet<QueryMetadata>(this.ksqlEngine.getPersistentQueries());
    }

    public List<PersistentQueryMetadata> getPersistentQueries() {
        return this.ksqlEngine.getPersistentQueries();
    }

    public Optional<PersistentQueryMetadata> getPersistentQuery(QueryId queryId) {
        return this.ksqlEngine.getPersistentQuery(queryId);
    }

    @Override
    public void close() {
        this.ksqlEngine.close();
        this.serviceContext.close();
    }

    @VisibleForTesting
    public void terminateQuery(QueryId queryId) {
        this.ksqlEngine.getPersistentQuery(queryId).ifPresent(t -> {
            t.close();
            this.ksqlEngine.removeQueryFromAssignor((PersistentQueryMetadata)t);
        });
    }

    @VisibleForTesting
    public void pauseQuery(QueryId queryId) {
        this.ksqlEngine.getPersistentQuery(queryId).ifPresent(QueryMetadata::pause);
    }

    @VisibleForTesting
    public void resumeQuery(QueryId queryId) {
        this.ksqlEngine.getPersistentQuery(queryId).ifPresent(QueryMetadata::resume);
    }

    private static KsqlExecutionContext.ExecuteResult execute(KsqlExecutionContext executionContext, KsqlParser.ParsedStatement stmt, KsqlConfig ksqlConfig, Map<String, Object> mutableSessionPropertyOverrides, Injector injector) {
        KsqlParser.PreparedStatement<?> prepared = executionContext.prepare(stmt);
        ConfiguredStatement<?> configured = injector.inject(ConfiguredStatement.of(prepared, SessionConfig.of((KsqlConfig)ksqlConfig, mutableSessionPropertyOverrides)));
        CustomExecutor executor = CustomExecutors.EXECUTOR_MAP.getOrDefault(configured.getStatement().getClass(), (passedExecutionContext, s, props) -> passedExecutionContext.execute(passedExecutionContext.getServiceContext(), s));
        return executor.apply(executionContext, configured, mutableSessionPropertyOverrides);
    }

    private static enum CustomExecutors {
        SET_PROPERTY(SetProperty.class, (executionContext, stmt, props) -> {
            PropertyOverrider.set(stmt, props);
            return KsqlExecutionContext.ExecuteResult.of("Successfully executed " + String.valueOf(stmt.getStatement()));
        }),
        UNSET_PROPERTY(UnsetProperty.class, (executionContext, stmt, props) -> {
            PropertyOverrider.unset(stmt, props);
            return KsqlExecutionContext.ExecuteResult.of("Successfully executed " + String.valueOf(stmt.getStatement()));
        }),
        QUERY(Query.class, (executionContext, stmt, props) -> KsqlExecutionContext.ExecuteResult.of(executionContext.executeTransientQuery(executionContext.getServiceContext(), stmt.cast(), false)));

        public static final Map<Class<? extends Statement>, CustomExecutor> EXECUTOR_MAP;
        private final Class<? extends Statement> statementClass;
        private final CustomExecutor executor;

        private CustomExecutors(Class<? extends Statement> statementClass, CustomExecutor executor) {
            this.statementClass = Objects.requireNonNull(statementClass, "statementClass");
            this.executor = Objects.requireNonNull(executor, "executor");
        }

        private Class<? extends Statement> getStatementClass() {
            return this.statementClass;
        }

        private CustomExecutor getExecutor() {
            return this::execute;
        }

        public KsqlExecutionContext.ExecuteResult execute(KsqlExecutionContext executionContext, ConfiguredStatement<?> statement, Map<String, Object> mutableSessionPropertyOverrides) {
            return this.executor.apply(executionContext, statement, mutableSessionPropertyOverrides);
        }

        static {
            EXECUTOR_MAP = ImmutableMap.copyOf(EnumSet.allOf(CustomExecutors.class).stream().collect(Collectors.toMap(CustomExecutors::getStatementClass, CustomExecutors::getExecutor)));
        }
    }

    @FunctionalInterface
    private static interface CustomExecutor {
        public KsqlExecutionContext.ExecuteResult apply(KsqlExecutionContext var1, ConfiguredStatement<?> var2, Map<String, Object> var3);
    }
}

