/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.EngineContext;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.engine.KsqlEngineProps;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.engine.PullQueryExecutionUtil;
import io.confluent.ksql.engine.QueryEngine;
import io.confluent.ksql.engine.QueryIdUtil;
import io.confluent.ksql.engine.QueryPlan;
import io.confluent.ksql.engine.ScalablePushQueryExecutionUtil;
import io.confluent.ksql.execution.ExecutionPlan;
import io.confluent.ksql.execution.ExecutionPlanner;
import io.confluent.ksql.execution.ddl.commands.CreateTableCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.execution.pull.HARouting;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.execution.pull.PullPhysicalPlanBuilder;
import io.confluent.ksql.execution.pull.PullQueryQueuePopulator;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.execution.pull.StreamedRowTranslator;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlan;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlanBuilder;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlanCreator;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlanManager;
import io.confluent.ksql.execution.scalablepush.PushQueryPreparer;
import io.confluent.ksql.execution.scalablepush.PushQueryQueuePopulator;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.InternalFunctionRegistry;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.logicalplanner.LogicalPlan;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.MetaStoreImpl;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metastore.model.KsqlTable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QueryContainer;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.physicalplanner.PhysicalPlan;
import io.confluent.ksql.physicalplanner.PhysicalPlanner;
import io.confluent.ksql.physicalplanner.nodes.Node;
import io.confluent.ksql.planner.LogicalPlanNode;
import io.confluent.ksql.planner.LogicalPlanner;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.KsqlBareOutputNode;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.VerifiableNode;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.QueryRegistry;
import io.confluent.ksql.query.TransientQueryQueue;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PlanSummary;
import io.confluent.ksql.util.PushOffsetRange;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import io.vertx.core.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class EngineExecutor {
    private static final Logger LOG = LogManager.getLogger(EngineExecutor.class);
    private static final String NO_OUTPUT_TOPIC_PREFIX = "";
    private final EngineContext engineContext;
    private final ServiceContext serviceContext;
    private final SessionConfig config;

    private EngineExecutor(EngineContext engineContext, ServiceContext serviceContext, SessionConfig config) {
        this.engineContext = Objects.requireNonNull(engineContext, "engineContext");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.config = Objects.requireNonNull(config, "config");
        KsqlEngineProps.throwOnImmutableOverride(config.getOverrides());
    }

    static EngineExecutor create(EngineContext engineContext, ServiceContext serviceContext, SessionConfig config) {
        return new EngineExecutor(engineContext, serviceContext, config);
    }

    KsqlExecutionContext.ExecuteResult execute(KsqlPlan plan) {
        return this.execute(plan, false);
    }

    KsqlExecutionContext.ExecuteResult execute(KsqlPlan plan, boolean restoreInProgress) {
        DataSource sinkSource;
        if (!plan.getQueryPlan().isPresent()) {
            String ddlResult = plan.getDdlCommand().map(ddl -> this.executeDdl((DdlCommand)ddl, plan.getStatementText(), false, Collections.emptySet(), restoreInProgress)).orElseThrow(() -> new IllegalStateException("DdlResult should be present if there is no physical plan."));
            return KsqlExecutionContext.ExecuteResult.of(ddlResult);
        }
        QueryPlan queryPlan = plan.getQueryPlan().get();
        KsqlConstants.PersistentQueryType persistentQueryType = plan.getPersistentQueryType().get();
        if (persistentQueryType != KsqlConstants.PersistentQueryType.CREATE_SOURCE && (sinkSource = this.engineContext.getMetaStore().getSource(queryPlan.getSink().get())) != null && sinkSource.isSource()) {
            throw new KsqlException(String.format("Cannot insert into read-only %s: %s", sinkSource.getDataSourceType().getKsqlType().toLowerCase(), sinkSource.getName().text()));
        }
        Optional<String> ddlResult = plan.getDdlCommand().map(ddl -> this.executeDdl((DdlCommand)ddl, plan.getStatementText(), true, queryPlan.getSources(), restoreInProgress));
        if (ddlResult.isPresent() && ddlResult.get().contains("already exists")) {
            return KsqlExecutionContext.ExecuteResult.of(ddlResult.get());
        }
        if (persistentQueryType == KsqlConstants.PersistentQueryType.CREATE_SOURCE && !this.isSourceTableMaterializationEnabled()) {
            QueryLogger.info((Object)String.format("Source table query won't be materialized because '%s' is disabled.", "ksql.source.table.materialization.enabled"), plan.getStatementText());
            return KsqlExecutionContext.ExecuteResult.of(ddlResult.get());
        }
        return KsqlExecutionContext.ExecuteResult.of(this.executePersistentQuery(queryPlan, plan.getStatementText(), persistentQueryType));
    }

    PullQueryResult executeTablePullQuery(ImmutableAnalysis analysis, ConfiguredStatement<Query> statement, HARouting routing, RoutingOptions routingOptions, QueryPlannerOptions queryPlannerOptions, Optional<PullQueryExecutorMetrics> pullQueryMetrics, boolean startImmediately, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        if (!statement.getStatement().isPullQuery()) {
            throw new IllegalArgumentException("Executor can only handle pull queries");
        }
        SessionConfig sessionConfig = statement.getSessionConfig();
        KsqlConstants.RoutingNodeType routingNodeType = routingOptions.getIsSkipForwardRequest() ? KsqlConstants.RoutingNodeType.REMOTE_NODE : KsqlConstants.RoutingNodeType.SOURCE_NODE;
        PullPhysicalPlan plan = null;
        try {
            KsqlConfig ksqlConfig = sessionConfig.getConfig(false);
            LogicalPlanNode logicalPlan = this.buildAndValidateLogicalPlan(statement, analysis, ksqlConfig, queryPlannerOptions, false);
            CompletableFuture<Void> shouldCancelRequests = new CompletableFuture<Void>();
            PullPhysicalPlan physicalPlan = plan = this.buildPullPhysicalPlan(logicalPlan, analysis, queryPlannerOptions, shouldCancelRequests, consistencyOffsetVector);
            PullQueryWriteStream pullQueryQueue = new PullQueryWriteStream(analysis.getLimitClause(), new StreamedRowTranslator(physicalPlan.getOutputSchema(), consistencyOffsetVector));
            PullQueryQueuePopulator populator = () -> routing.handlePullQuery(this.serviceContext, physicalPlan, statement, routingOptions, pullQueryQueue, shouldCancelRequests);
            PullQueryResult result = new PullQueryResult(physicalPlan.getOutputSchema(), populator, physicalPlan.getQueryId(), pullQueryQueue, pullQueryMetrics, physicalPlan.getSourceType(), physicalPlan.getPlanType(), routingNodeType, physicalPlan::getRowsReadFromDataSource, shouldCancelRequests, consistencyOffsetVector);
            if (startImmediately) {
                result.start();
            }
            return result;
        }
        catch (Exception e) {
            if (plan == null) {
                pullQueryMetrics.ifPresent(m -> m.recordErrorRateForNoResult(1.0));
            } else {
                PullPhysicalPlan physicalPlan = plan;
                pullQueryMetrics.ifPresent(metrics -> metrics.recordErrorRate(1.0, physicalPlan.getSourceType(), physicalPlan.getPlanType(), routingNodeType));
            }
            QueryLogger.error("Failure to execute pull query", statement.getMaskedStatementText(), e);
            if (e instanceof KsqlServerException) {
                throw e;
            }
            if (e instanceof KsqlStatementException) {
                throw new KsqlStatementException(e.getMessage() == null ? "Server Error" : e.getMessage(), ((KsqlStatementException)((Object)e)).getUnloggedMessage(), statement.getMaskedStatementText(), (Throwable)e);
            }
            throw new KsqlStatementException(e.getMessage() == null ? "Server Error" : e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
    }

    ScalablePushQueryMetadata executeScalablePushQuery(ImmutableAnalysis analysis, ConfiguredStatement<Query> statement, PushRouting pushRouting, PushRoutingOptions pushRoutingOptions, QueryPlannerOptions queryPlannerOptions, Context context, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics) {
        SessionConfig sessionConfig = statement.getSessionConfig();
        KsqlConstants.RoutingNodeType routingNodeType = pushRoutingOptions.getHasBeenForwarded() ? KsqlConstants.RoutingNodeType.REMOTE_NODE : KsqlConstants.RoutingNodeType.SOURCE_NODE;
        PushPhysicalPlan plan = null;
        try {
            PushPhysicalPlan physicalPlan;
            KsqlConfig ksqlConfig = sessionConfig.getConfig(false);
            LogicalPlanNode logicalPlan = this.buildAndValidateLogicalPlan(statement, analysis, ksqlConfig, queryPlannerOptions, true);
            PushPhysicalPlanCreator pushPhysicalPlanCreator = (offsetRange, catchupConsumerGroup) -> this.buildScalablePushPhysicalPlan(logicalPlan, analysis, context, offsetRange, catchupConsumerGroup);
            Optional<PushOffsetRange> offsetRange2 = pushRoutingOptions.getContinuationToken().map(PushOffsetRange::deserialize);
            Optional<String> catchupConsumerGroup2 = pushRoutingOptions.getCatchupConsumerGroup();
            PushPhysicalPlanManager physicalPlanManager = new PushPhysicalPlanManager(pushPhysicalPlanCreator, catchupConsumerGroup2, offsetRange2);
            plan = physicalPlan = physicalPlanManager.getPhysicalPlan();
            TransientQueryQueue transientQueryQueue = new TransientQueryQueue(analysis.getLimitClause());
            PushQueryMetadata.ResultType resultType = physicalPlan.getScalablePushRegistry().isTable() ? (physicalPlan.getScalablePushRegistry().isWindowed() ? PushQueryMetadata.ResultType.WINDOWED_TABLE : PushQueryMetadata.ResultType.TABLE) : PushQueryMetadata.ResultType.STREAM;
            PushQueryQueuePopulator populator = () -> pushRouting.handlePushQuery(this.serviceContext, physicalPlanManager, statement, pushRoutingOptions, physicalPlan.getOutputSchema(), transientQueryQueue, scalablePushQueryMetrics, offsetRange2);
            PushQueryPreparer preparer = () -> pushRouting.preparePushQuery(physicalPlanManager, statement, pushRoutingOptions);
            ScalablePushQueryMetadata metadata = new ScalablePushQueryMetadata(physicalPlan.getOutputSchema(), physicalPlan.getQueryId(), transientQueryQueue, scalablePushQueryMetrics, resultType, populator, preparer, physicalPlan.getSourceType(), routingNodeType, physicalPlan::getRowsReadFromDataSource);
            return metadata;
        }
        catch (Exception e) {
            if (plan == null) {
                scalablePushQueryMetrics.ifPresent(m -> m.recordErrorRateForNoResult(1.0));
            } else {
                PushPhysicalPlan pushPhysicalPlan = plan;
                scalablePushQueryMetrics.ifPresent(metrics -> metrics.recordErrorRate(1.0, pushPhysicalPlan.getSourceType(), routingNodeType));
            }
            QueryLogger.error("Failure to execute push query V2. " + pushRoutingOptions.debugString() + " " + queryPlannerOptions.debugString(), statement.getMaskedStatementText(), e);
            if (e instanceof KsqlStatementException) {
                throw new KsqlStatementException(e.getMessage() == null ? "Server Error" : e.getMessage(), ((KsqlStatementException)((Object)e)).getUnloggedMessage(), statement.getMaskedStatementText(), (Throwable)e);
            }
            throw new KsqlStatementException(e.getMessage() == null ? "Server Error" : e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
    }

    TransientQueryMetadata executeTransientQuery(ConfiguredStatement<Query> statement, boolean excludeTombstones) {
        ExecutorPlans plans = this.planQuery(statement, statement.getStatement(), Optional.empty(), Optional.empty(), (MetaStore)this.engineContext.getMetaStore());
        KsqlBareOutputNode outputNode = (KsqlBareOutputNode)plans.outputNode;
        this.engineContext.createQueryValidator().validateQuery(this.config, plans.executionPlan, this.engineContext.getQueryRegistry().getAllLiveQueries());
        return this.engineContext.getQueryRegistry().createTransientQuery(this.config, this.serviceContext, this.engineContext.getProcessingLogContext(), (MetaStore)this.engineContext.getMetaStore(), statement.getMaskedStatementText(), plans.executionPlan.getQueryId(), EngineExecutor.getSourceNames(outputNode), plans.executionPlan.getPhysicalPlan(), this.buildPlanSummary(plans.executionPlan.getQueryId(), plans.executionPlan.getPhysicalPlan()), outputNode.getSchema(), outputNode.getLimit(), outputNode.getWindowInfo(), excludeTombstones);
    }

    TransientQueryMetadata executeStreamPullQuery(ConfiguredStatement<Query> statement, boolean excludeTombstones, ImmutableMap<TopicPartition, Long> endOffsets) {
        ExecutorPlans plans = this.planQuery(statement, statement.getStatement(), Optional.empty(), Optional.empty(), (MetaStore)this.engineContext.getMetaStore());
        KsqlBareOutputNode outputNode = (KsqlBareOutputNode)plans.outputNode;
        this.engineContext.createQueryValidator().validateQuery(this.config, plans.executionPlan, this.engineContext.getQueryRegistry().getAllLiveQueries());
        return this.engineContext.getQueryRegistry().createStreamPullQuery(this.config, this.serviceContext, this.engineContext.getProcessingLogContext(), (MetaStore)this.engineContext.getMetaStore(), statement.getMaskedStatementText(), plans.executionPlan.getQueryId(), EngineExecutor.getSourceNames(outputNode), plans.executionPlan.getPhysicalPlan(), this.buildPlanSummary(plans.executionPlan.getQueryId(), plans.executionPlan.getPhysicalPlan()), outputNode.getSchema(), outputNode.getLimit(), outputNode.getWindowInfo(), excludeTombstones, endOffsets);
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"})
    private KsqlPlan sourceTablePlan(ConfiguredStatement<?> statement) {
        CreateTable createTable = (CreateTable)statement.getStatement();
        CreateTableCommand ddlCommand = (CreateTableCommand)this.engineContext.createDdlCommand(statement.getMaskedStatementText(), (ExecutableDdlStatement)statement.getStatement(), this.config);
        AliasedRelation from = new AliasedRelation((Relation)new Table(createTable.getName()), createTable.getName());
        Select select = new Select(createTable.getElements().stream().filter(column -> !column.getConstraints().isKey() && !column.getConstraints().isPrimaryKey()).map(column -> new SingleColumn((Expression)new UnqualifiedColumnReferenceExp(column.getName()), Optional.of(column.getName()))).collect(Collectors.toList()));
        RefinementInfo refinementInfo = RefinementInfo.of((OutputRefinement)OutputRefinement.CHANGES);
        Query query = new Query(Optional.empty(), select, (Relation)from, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(refinementInfo), false, OptionalInt.empty());
        MetaStoreImpl tempMetastore = new MetaStoreImpl((FunctionRegistry)new InternalFunctionRegistry());
        Formats formats = ddlCommand.getFormats();
        tempMetastore.putSource((DataSource)new KsqlTable(statement.getMaskedStatementText(), createTable.getName(), ddlCommand.getSchema(), Optional.empty(), false, new KsqlTopic(ddlCommand.getTopicName(), KeyFormat.of((FormatInfo)formats.getKeyFormat(), (SerdeFeatures)formats.getKeyFeatures(), Optional.empty()), ValueFormat.of((FormatInfo)formats.getValueFormat(), (SerdeFeatures)formats.getValueFeatures())), true), false);
        ExecutorPlans plans = this.planQuery(statement, query, Optional.empty(), Optional.empty(), (MetaStore)tempMetastore);
        KsqlBareOutputNode outputNode = (KsqlBareOutputNode)plans.outputNode;
        QueryPlan queryPlan = new QueryPlan(EngineExecutor.getSourceNames(outputNode), Optional.empty(), plans.executionPlan.getPhysicalPlan(), plans.executionPlan.getQueryId(), this.getApplicationId(plans.executionPlan.getQueryId(), EngineExecutor.getSourceTopicNames(outputNode)));
        this.engineContext.createQueryValidator().validateQuery(this.config, plans.executionPlan, this.engineContext.getQueryRegistry().getAllLiveQueries());
        return KsqlPlan.queryPlanCurrent(statement.getMaskedStatementText(), Optional.of(ddlCommand), queryPlan);
    }

    private boolean isSourceTableMaterializationEnabled() {
        return this.config.getConfig(false).getBoolean("ksql.source.table.materialization.enabled");
    }

    KsqlPlan plan(ConfiguredStatement<?> statement) {
        try {
            EngineExecutor.throwOnNonExecutableStatement(statement);
            if (statement.getStatement() instanceof ExecutableDdlStatement) {
                boolean isSourceTable;
                boolean isSourceStream = statement.getStatement() instanceof CreateStream && ((CreateStream)statement.getStatement()).isSource();
                boolean bl = isSourceTable = statement.getStatement() instanceof CreateTable && ((CreateTable)statement.getStatement()).isSource();
                if ((isSourceStream || isSourceTable) && !this.isSourceTableMaterializationEnabled()) {
                    throw new KsqlStatementException("Cannot execute command because source table materialization is disabled.", statement.getMaskedStatementText());
                }
                if (isSourceTable) {
                    return this.sourceTablePlan(statement);
                }
                DdlCommand ddlCommand = this.engineContext.createDdlCommand(statement.getMaskedStatementText(), (ExecutableDdlStatement)statement.getStatement(), this.config);
                return KsqlPlan.ddlPlanCurrent(statement.getMaskedStatementText(), ddlCommand);
            }
            QueryContainer queryContainer = (QueryContainer)statement.getStatement();
            ExecutorPlans plans = this.planQuery(statement, queryContainer.getQuery(), Optional.of(queryContainer.getSink()), queryContainer.getQueryId(), (MetaStore)this.engineContext.getMetaStore());
            KsqlStructuredDataOutputNode outputNode = (KsqlStructuredDataOutputNode)plans.outputNode;
            Optional<DdlCommand> ddlCommand = this.maybeCreateSinkDdl(statement, outputNode);
            EngineExecutor.validateResultType(outputNode.getNodeOutputType(), statement);
            QueryPlan queryPlan = new QueryPlan(EngineExecutor.getSourceNames(outputNode), outputNode.getSinkName(), plans.executionPlan.getPhysicalPlan(), plans.executionPlan.getQueryId(), this.getApplicationId(plans.executionPlan.getQueryId(), EngineExecutor.getSourceTopicNames(outputNode)));
            this.engineContext.createQueryValidator().validateQuery(this.config, plans.executionPlan, this.engineContext.getQueryRegistry().getAllLiveQueries());
            return KsqlPlan.queryPlanCurrent(statement.getMaskedStatementText(), ddlCommand, queryPlan);
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KsqlStatementException(e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
    }

    private Optional<String> getApplicationId(QueryId queryId, Collection<String> sources) {
        return this.config.getConfig(true).getBoolean("ksql.runtime.feature.shared.enabled") != false ? Optional.of(this.engineContext.getRuntimeAssignor().getRuntimeAndMaybeAddRuntime(queryId, sources, this.config.getConfig(true))) : Optional.empty();
    }

    private void throwIfUnsupported(Query query) {
        if (query.isPullQuery()) {
            throw new IllegalStateException();
        }
        if (query.getWhere().isPresent()) {
            throw new UnsupportedOperationException("New query planner does not support WHERE. Set ksql.new.query.planner.enabled=false.");
        }
        if (query.getGroupBy().isPresent()) {
            throw new UnsupportedOperationException("New query planner does not support GROUP BY. Set ksql.new.query.planner.enabled=false.");
        }
        if (query.getHaving().isPresent()) {
            throw new UnsupportedOperationException("New query planner does not support HAVING. Set ksql.new.query.planner.enabled=false.");
        }
        if (query.getWindow().isPresent()) {
            throw new UnsupportedOperationException("New query planner does not support WINDOWS. Set ksql.new.query.planner.enabled=false.");
        }
        if (query.getPartitionBy().isPresent()) {
            throw new UnsupportedOperationException("New query planner does not support PARTITION BY. Set ksql.new.query.planner.enabled=false.");
        }
        if (query.getLimit().isPresent()) {
            throw new UnsupportedOperationException("New query planner does not support LIMIT. Set ksql.new.query.planner.enabled=false.");
        }
        Relation fromClause = query.getFrom();
        if (fromClause instanceof Join) {
            throw new UnsupportedOperationException("New query planner does not support joins. Set ksql.new.query.planner.enabled=false.");
        }
        if (fromClause instanceof JoinedSource) {
            throw new IllegalStateException();
        }
    }

    private ExecutorPlans planQuery(ConfiguredStatement<?> statement, Query query, Optional<Sink> sink, Optional<String> withQueryId, MetaStore metaStore) {
        Optional<PlanInfo> oldPlanInfo;
        QueryEngine queryEngine = this.engineContext.createQueryEngine(this.serviceContext);
        KsqlConfig ksqlConfig = this.config.getConfig(true);
        if (ksqlConfig.getBoolean("ksql.new.query.planner.enabled").booleanValue()) {
            this.throwIfUnsupported(query);
            LogicalPlan logicalPlan = io.confluent.ksql.logicalplanner.LogicalPlanner.buildPlan(metaStore, query);
            PhysicalPlan physicalPlan = PhysicalPlanner.buildPlan(metaStore, logicalPlan);
            Node<?> root = physicalPlan.getRoot();
            LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
            logicalPlan.getRoot().getOutputSchema().forEach(column -> {
                if (root.keyColumnNames().contains((Object)column.name())) {
                    schemaBuilder.keyColumn(column.name(), column.type());
                } else {
                    schemaBuilder.valueColumn(column.name(), column.type());
                }
            });
            return new ExecutorPlans(new StubbedOutputNode(metaStore.getSource((SourceName)logicalPlan.getSourceNames().stream().findFirst().get()), EngineExecutor.getSinkTopic(root.getFormats(), sink.get()), schemaBuilder.build()), ExecutionPlanner.buildPlan(metaStore, physicalPlan, sink.get()));
        }
        OutputNode outputNode = QueryEngine.buildQueryLogicalPlan(query, sink, metaStore, ksqlConfig, statement.getMaskedStatementText());
        LogicalPlanNode logicalPlan = new LogicalPlanNode(Optional.of(outputNode));
        QueryId queryId = QueryIdUtil.buildId(statement.getStatement(), this.engineContext, this.engineContext.idGenerator(), outputNode, ksqlConfig.getBoolean("ksql.create.or.replace.enabled"), withQueryId);
        if (withQueryId.isPresent() && this.engineContext.getQueryRegistry().getPersistentQuery(queryId).isPresent()) {
            throw new KsqlException(String.format("Query ID '%s' already exists.", queryId));
        }
        Optional<PersistentQueryMetadata> persistentQueryMetadata = this.engineContext.getQueryRegistry().getPersistentQuery(queryId);
        if (persistentQueryMetadata.isPresent()) {
            ExecutionStep<?> oldPlan = persistentQueryMetadata.get().getPhysicalPlan();
            oldPlanInfo = Optional.of(oldPlan.extractPlanInfo(new PlanInfoExtractor()));
        } else {
            oldPlanInfo = Optional.empty();
        }
        ExecutionPlan executionPlan = queryEngine.buildPhysicalPlan(logicalPlan, this.config, metaStore, queryId, oldPlanInfo);
        return new ExecutorPlans(logicalPlan.getNode().get(), executionPlan);
    }

    private static KsqlTopic getSinkTopic(Formats formats, Sink sink) {
        SerdeFeatures valueFeatures;
        FormatInfo valueFormatInfo;
        SerdeFeatures keyFeatures;
        FormatInfo keyFormatInfo;
        CreateSourceAsProperties properties = sink.getProperties();
        Optional keyFormatName = properties.getKeyFormat();
        if (keyFormatName.isPresent()) {
            keyFormatInfo = FormatInfo.of((String)((String)keyFormatName.get()));
            keyFeatures = SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        } else {
            keyFormatInfo = formats.getKeyFormat();
            keyFeatures = formats.getKeyFeatures();
        }
        Optional valueFormatName = properties.getValueFormat();
        if (valueFormatName.isPresent()) {
            valueFormatInfo = FormatInfo.of((String)((String)valueFormatName.get()));
            valueFeatures = SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        } else {
            valueFormatInfo = formats.getValueFormat();
            valueFeatures = formats.getValueFeatures();
        }
        KeyFormat keyFormat = KeyFormat.nonWindowed((FormatInfo)keyFormatInfo, (SerdeFeatures)keyFeatures);
        ValueFormat valueFormat = ValueFormat.of((FormatInfo)valueFormatInfo, (SerdeFeatures)valueFeatures);
        return new KsqlTopic(sink.getName().text(), keyFormat, valueFormat);
    }

    private LogicalPlanNode buildAndValidateLogicalPlan(ConfiguredStatement<?> statement, ImmutableAnalysis analysis, KsqlConfig config, QueryPlannerOptions queryPlannerOptions, boolean isScalablePush) {
        OutputNode outputNode = new LogicalPlanner(config, analysis, (MetaStore)this.engineContext.getMetaStore()).buildQueryLogicalPlan(queryPlannerOptions, isScalablePush);
        return new LogicalPlanNode(Optional.of(outputNode));
    }

    private PushPhysicalPlan buildScalablePushPhysicalPlan(LogicalPlanNode logicalPlan, ImmutableAnalysis analysis, Context context, Optional<PushOffsetRange> offsetRange, Optional<String> catchupConsumerGroup) {
        PushPhysicalPlanBuilder builder = new PushPhysicalPlanBuilder(this.engineContext.getProcessingLogContext(), ScalablePushQueryExecutionUtil.findQuery(this.engineContext, analysis));
        return builder.buildPushPhysicalPlan(logicalPlan, context, offsetRange, catchupConsumerGroup);
    }

    private PullPhysicalPlan buildPullPhysicalPlan(LogicalPlanNode logicalPlan, ImmutableAnalysis analysis, QueryPlannerOptions queryPlannerOptions, CompletableFuture<Void> shouldCancelRequests, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        PullPhysicalPlanBuilder builder = new PullPhysicalPlanBuilder(this.engineContext.getProcessingLogContext(), PullQueryExecutionUtil.findMaterializingQuery(this.engineContext, analysis), analysis, queryPlannerOptions, shouldCancelRequests, consistencyOffsetVector);
        return builder.buildPullPhysicalPlan(logicalPlan);
    }

    private Optional<DdlCommand> maybeCreateSinkDdl(ConfiguredStatement<?> cfgStatement, KsqlStructuredDataOutputNode outputNode) {
        if (!outputNode.createInto()) {
            this.validateExistingSink(outputNode);
            return Optional.empty();
        }
        Object statement = cfgStatement.getStatement();
        SourceName intoSource = outputNode.getSinkName().get();
        boolean orReplace = statement instanceof CreateAsSelect && ((CreateAsSelect)statement).isOrReplace();
        boolean ifNotExists = statement instanceof CreateAsSelect && ((CreateAsSelect)statement).isNotExists();
        DataSource dataSource = this.engineContext.getMetaStore().getSource(intoSource);
        if (dataSource != null && !ifNotExists && !orReplace) {
            String failedSourceType = outputNode.getNodeOutputType().getKsqlType();
            String foundSourceType = dataSource.getDataSourceType().getKsqlType();
            throw new KsqlException(String.format("Cannot add %s '%s': A %s with the same name already exists", failedSourceType.toLowerCase(), intoSource.text(), foundSourceType.toLowerCase()));
        }
        return Optional.of(this.engineContext.createDdlCommand(outputNode, ((QueryContainer)statement).getQuery().getRefinement()));
    }

    private void validateExistingSink(KsqlStructuredDataOutputNode outputNode) {
        LogicalSchema existingSchema;
        SourceName name = outputNode.getSinkName().get();
        DataSource existing = this.engineContext.getMetaStore().getSource(name);
        if (existing == null) {
            throw new KsqlException(String.format("%s does not exist.", outputNode));
        }
        if (existing.getDataSourceType() != outputNode.getNodeOutputType()) {
            throw new KsqlException(String.format("Incompatible data sink and query result. Data sink (%s) type is %s but select query result is %s.", name.text(), existing.getDataSourceType(), outputNode.getNodeOutputType()));
        }
        LogicalSchema resultSchema = outputNode.getSchema();
        if (!resultSchema.compatibleSchema(existingSchema = existing.getSchema())) {
            throw new KsqlException("Incompatible schema between results and sink." + System.lineSeparator() + "Result schema is " + String.valueOf(resultSchema) + System.lineSeparator() + "Sink schema is " + String.valueOf(existingSchema));
        }
    }

    private static void validateResultType(DataSource.DataSourceType dataSourceType, ConfiguredStatement<?> statement) {
        if (statement.getStatement() instanceof CreateStreamAsSelect && dataSourceType == DataSource.DataSourceType.KTABLE) {
            throw new KsqlStatementException("Invalid result type. Your SELECT query produces a TABLE. Please use CREATE TABLE AS SELECT statement instead.", statement.getMaskedStatementText());
        }
        if (statement.getStatement() instanceof CreateTableAsSelect && dataSourceType == DataSource.DataSourceType.KSTREAM) {
            throw new KsqlStatementException("Invalid result type. Your SELECT query produces a STREAM. Please use CREATE STREAM AS SELECT statement instead.", statement.getMaskedStatementText());
        }
    }

    private static void throwOnNonExecutableStatement(ConfiguredStatement<?> statement) {
        if (!KsqlEngine.isExecutableStatement(statement.getStatement())) {
            throw new KsqlStatementException("Statement not executable", statement.getMaskedStatementText());
        }
    }

    private static Set<SourceName> getSourceNames(PlanNode outputNode) {
        return outputNode.getSourceNodes().map(DataSourceNode::getDataSource).map(DataSource::getName).collect(Collectors.toSet());
    }

    private static Set<String> getSourceTopicNames(PlanNode outputNode) {
        return outputNode.getSourceNodes().map(DataSourceNode::getDataSource).map(DataSource::getKsqlTopic).map(KsqlTopic::getKafkaTopicName).collect(Collectors.toSet());
    }

    private String executeDdl(DdlCommand ddlCommand, String statementText, boolean withQuery, Set<SourceName> withQuerySources, boolean restoreInProgress) {
        try {
            return this.engineContext.executeDdl(statementText, ddlCommand, withQuery, withQuerySources, restoreInProgress);
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KsqlStatementException(e.getMessage(), statementText, (Throwable)e);
        }
    }

    private Set<DataSource> getSources(QueryPlan queryPlan) {
        ImmutableSet.Builder sources = ImmutableSet.builder();
        for (SourceName name : queryPlan.getSources()) {
            DataSource dataSource = this.engineContext.getMetaStore().getSource(name);
            if (dataSource == null) {
                throw new KsqlException("Unknown source: " + name.toString(FormatOptions.noEscape()));
            }
            sources.add((Object)dataSource);
        }
        return sources.build();
    }

    private PersistentQueryMetadata executePersistentQuery(QueryPlan queryPlan, String statementText, KsqlConstants.PersistentQueryType persistentQueryType) {
        QueryRegistry queryRegistry = this.engineContext.getQueryRegistry();
        return queryRegistry.createOrReplacePersistentQuery(this.config, this.serviceContext, this.engineContext.getProcessingLogContext(), (MetaStore)this.engineContext.getMetaStore(), statementText, queryPlan.getQueryId(), queryPlan.getSink().map(s -> this.engineContext.getMetaStore().getSource(s)), this.getSources(queryPlan), queryPlan.getPhysicalPlan(), this.buildPlanSummary(queryPlan.getQueryId(), queryPlan.getPhysicalPlan()), persistentQueryType, queryPlan.getRuntimeId());
    }

    private String buildPlanSummary(QueryId queryId, ExecutionStep<?> plan) {
        return new PlanSummary(queryId, this.config.getConfig(true), (MetaStore)this.engineContext.getMetaStore()).summarize(plan);
    }

    private static final class ExecutorPlans {
        private final OutputNode outputNode;
        private final ExecutionPlan executionPlan;

        private ExecutorPlans(OutputNode outputNode, ExecutionPlan executionPlan) {
            this.outputNode = Objects.requireNonNull(outputNode, "outputNode");
            this.executionPlan = Objects.requireNonNull(executionPlan, "physicalPlanNode");
        }
    }

    private static final class StubbedOutputNode
    extends KsqlStructuredDataOutputNode {
        private StubbedOutputNode(DataSource source, KsqlTopic sinkTopic, LogicalSchema sinkSchema) {
            super(new PlanNodeId("stubbedOutput"), new StubbedVerifiableDataSourceNode(new PlanNodeId("stubbedSource"), source, source.getName(), false), sinkSchema, Optional.empty(), sinkTopic, OptionalInt.empty(), true, SourceName.of((String)sinkTopic.getKafkaTopicName()), false);
        }
    }

    private static final class StubbedVerifiableDataSourceNode
    extends DataSourceNode
    implements VerifiableNode {
        private StubbedVerifiableDataSourceNode(PlanNodeId id, DataSource dataSource, SourceName alias, boolean isWindowed) {
            super(id, dataSource, alias, isWindowed);
        }

        @Override
        public void validateKeyPresent(SourceName sinkName) {
        }

        @Override
        public LogicalSchema getSchema() {
            return LogicalSchema.builder().build();
        }
    }
}

