/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.ksql.engine.KsqlPlanV1;
import io.confluent.ksql.engine.QueryPlan;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.util.KsqlConstants;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=KsqlPlanV1.class, name="ksqlPlanV1")})
public interface KsqlPlan {
    public Optional<DdlCommand> getDdlCommand();

    public Optional<QueryPlan> getQueryPlan();

    public String getStatementText();

    public KsqlPlan withoutQuery();

    @JsonIgnore
    public Optional<KsqlConstants.PersistentQueryType> getPersistentQueryType();

    public static KsqlPlan ddlPlanCurrent(String statementText, DdlCommand ddlCommand) {
        return new KsqlPlanV1(statementText, Optional.of(ddlCommand), Optional.empty());
    }

    public static KsqlPlan queryPlanCurrent(String maskedStatement, Optional<DdlCommand> ddlCommand, QueryPlan queryPlan) {
        return new KsqlPlanV1(maskedStatement, ddlCommand, Optional.of(queryPlan));
    }
}

