/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.spun.util.io.FileUtils;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.QueryApplicationId;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryCleanupService
extends AbstractExecutionThreadService {
    private static final Logger LOG = LogManager.getLogger(QueryCleanupService.class);
    private static final Runnable SHUTDOWN_SENTINEL = () -> {};
    private final BlockingQueue<Runnable> cleanupTasks = new LinkedBlockingDeque<Runnable>();

    protected void run() {
        try {
            while (true) {
                Runnable task;
                if ((task = this.cleanupTasks.take()) == SHUTDOWN_SENTINEL) {
                    return;
                }
                task.run();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    protected void triggerShutdown() {
        this.cleanupTasks.add(SHUTDOWN_SENTINEL);
    }

    public Set<String> pendingApplicationIds() {
        return (Set)this.cleanupTasks.stream().filter(QueryCleanupTask.class::isInstance).map(QueryCleanupTask.class::cast).map(t -> t.appId).collect(ImmutableSet.toImmutableSet());
    }

    public boolean isEmpty() {
        return this.cleanupTasks.isEmpty();
    }

    public void addCleanupTask(QueryCleanupTask task) {
        this.cleanupTasks.add(task);
    }

    public static class QueryCleanupTask
    implements Runnable {
        private final String appId;
        private final String queryTopicPrefix;
        private final String altQueryTopicPrefix;
        private final String pathName;
        private final ServiceContext serviceContext;

        public QueryCleanupTask(ServiceContext serviceContext, String appId, Optional<String> queryId, boolean isTransient, String stateDir, String serviceId, String persistentQueryPrefix) {
            this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
            this.appId = Objects.requireNonNull(appId, "appId");
            this.queryTopicPrefix = queryId.map(s -> QueryApplicationId.buildInternalTopicPrefix((String)serviceId, (String)persistentQueryPrefix) + s).orElse(appId);
            this.altQueryTopicPrefix = queryId.map(s -> QueryApplicationId.buildInternalTopicPrefix((String)serviceId, (String)(persistentQueryPrefix.split("_")[0] + "-")) + s).orElse(appId);
            this.pathName = queryId.map(s -> stateDir + "/" + appId + "/__" + s + "__").orElse(stateDir + "/" + appId);
            if (isTransient && queryId.isPresent()) {
                throw new IllegalArgumentException("Transient Queries can not have named topologies");
            }
        }

        public String getAppId() {
            return this.appId;
        }

        @Override
        public void run() {
            try {
                Path pathName = Paths.get(this.pathName, new String[0]);
                File directory = new File(String.valueOf(pathName.normalize()));
                if (directory.exists()) {
                    FileUtils.deleteDirectory((File)directory);
                    LOG.warn("Deleted local state store for non-existing query {}. This is not expected and was likely due to a race condition when the query was dropped before.", (Object)this.queryTopicPrefix);
                }
            }
            catch (Exception e) {
                LOG.error("Error cleaning up state directory {}\n. {}", (Object)this.pathName, (Object)e);
            }
            this.tryRun(() -> {
                LOG.info("Deleting schemas for prefix {}", (Object)this.queryTopicPrefix);
                SchemaRegistryUtil.cleanupInternalTopicSchemas(this.queryTopicPrefix, this.serviceContext.getSchemaRegistryClient());
            }, "internal topic schemas");
            this.tryRun(() -> {
                LOG.info("Deleting topics for prefix {}", (Object)this.queryTopicPrefix);
                this.serviceContext.getTopicClient().deleteInternalTopics(this.queryTopicPrefix);
                this.serviceContext.getTopicClient().deleteInternalTopics(this.altQueryTopicPrefix);
            }, "internal topics");
            LOG.info("Deleting offsets for appId: {}", (Object)this.appId);
            this.tryRun(() -> this.serviceContext.getConsumerGroupClient().deleteConsumerGroups((Set)ImmutableSet.of((Object)this.appId)), "internal consumer groups");
        }

        private void tryRun(Runnable runnable, String resource) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.warn("Failed to cleanup {} for {}", (Object)resource, (Object)this.appId, (Object)e);
            }
        }
    }
}

