/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.engine.EngineContext;
import io.confluent.ksql.engine.EngineExecutor;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.execution.pull.HARouting;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.ConfiguredKsqlPlan;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PersistentQueryMetadataImpl;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.Sandbox;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.StreamPullQueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import io.vertx.core.Context;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Sandbox
final class SandboxedExecutionContext
implements KsqlExecutionContext {
    private final EngineContext engineContext;
    private final MetricCollectors metricCollectors;

    SandboxedExecutionContext(EngineContext sourceContext, ServiceContext serviceContext, MetricCollectors metricCollectors) {
        this.metricCollectors = metricCollectors;
        this.engineContext = sourceContext.createSandbox(serviceContext);
    }

    @Override
    public KsqlConfig getKsqlConfig() {
        return this.engineContext.getKsqlConfig();
    }

    @Override
    public MetricCollectors metricCollectors() {
        return this.metricCollectors;
    }

    @Override
    public void alterSystemProperty(String propertyName, String propertyValue) {
        ImmutableMap overrides = ImmutableMap.of((Object)propertyName, (Object)propertyValue);
        this.engineContext.alterSystemProperty((Map<String, String>)overrides);
    }

    @Override
    public MetaStore getMetaStore() {
        return this.engineContext.getMetaStore();
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.engineContext.getServiceContext();
    }

    @Override
    public ProcessingLogContext getProcessingLogContext() {
        return NoopProcessingLogContext.INSTANCE;
    }

    @Override
    public KsqlExecutionContext createSandbox(ServiceContext serviceContext) {
        return new SandboxedExecutionContext(this.engineContext, serviceContext, this.metricCollectors);
    }

    @Override
    public Optional<PersistentQueryMetadata> getPersistentQuery(QueryId queryId) {
        return this.engineContext.getQueryRegistry().getPersistentQuery(queryId);
    }

    @Override
    public Optional<QueryMetadata> getQuery(QueryId queryId) {
        return this.engineContext.getQueryRegistry().getQuery(queryId);
    }

    @Override
    public List<PersistentQueryMetadata> getPersistentQueries() {
        return ImmutableList.copyOf(this.engineContext.getQueryRegistry().getPersistentQueries().values());
    }

    @Override
    public Set<QueryId> getQueriesWithSink(SourceName sourceName) {
        return this.engineContext.getQueryRegistry().getQueriesWithSink(sourceName);
    }

    @Override
    public List<QueryMetadata> getAllLiveQueries() {
        return this.engineContext.getQueryRegistry().getAllLiveQueries();
    }

    @Override
    public List<KsqlParser.ParsedStatement> parse(String sql) {
        return this.engineContext.parse(sql);
    }

    @Override
    public KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement stmt, Map<String, String> variablesMap) {
        return this.engineContext.prepare(stmt, variablesMap);
    }

    @Override
    public KsqlPlan plan(ServiceContext serviceContext, ConfiguredStatement<?> statement) {
        return EngineExecutor.create(this.engineContext, serviceContext, statement.getSessionConfig()).plan(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KsqlExecutionContext.ExecuteResult execute(ServiceContext serviceContext, ConfiguredKsqlPlan ksqlPlan, boolean restoreInProgress) {
        try {
            KsqlExecutionContext.ExecuteResult result = EngineExecutor.create(this.engineContext, serviceContext, ksqlPlan.getConfig()).execute(ksqlPlan.getPlan(), restoreInProgress);
            if (result.getQuery().isPresent() && result.getQuery().get() instanceof PersistentQueryMetadataImpl) {
                result.getQuery().map(QueryMetadata::getKafkaStreams).ifPresent(streams -> streams.close());
            }
            KsqlExecutionContext.ExecuteResult executeResult = result;
            return executeResult;
        }
        finally {
            if (this.getKsqlConfig().getBoolean("ksql.runtime.feature.shared.enabled").booleanValue()) {
                this.engineContext.getQueryRegistry().closeRuntimes();
            }
        }
    }

    @Override
    public KsqlExecutionContext.ExecuteResult execute(ServiceContext serviceContext, ConfiguredStatement<?> statement) {
        return this.execute(serviceContext, ConfiguredKsqlPlan.of(this.plan(serviceContext, statement), statement.getSessionConfig()));
    }

    @Override
    public TransientQueryMetadata executeTransientQuery(ServiceContext serviceContext, ConfiguredStatement<Query> statement, boolean excludeTombstones) {
        return EngineExecutor.create(this.engineContext, serviceContext, statement.getSessionConfig()).executeTransientQuery(statement, excludeTombstones);
    }

    @Override
    public PullQueryResult executeTablePullQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, ConfiguredStatement<Query> statement, HARouting routing, RoutingOptions routingOptions, QueryPlannerOptions queryPlannerOptions, Optional<PullQueryExecutorMetrics> pullQueryMetrics, boolean startImmediately, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        return EngineExecutor.create(this.engineContext, serviceContext, statement.getSessionConfig()).executeTablePullQuery(analysis, statement, routing, routingOptions, queryPlannerOptions, pullQueryMetrics, startImmediately, consistencyOffsetVector);
    }

    @Override
    public ScalablePushQueryMetadata executeScalablePushQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, ConfiguredStatement<Query> statement, PushRouting pushRouting, PushRoutingOptions pushRoutingOptions, QueryPlannerOptions queryPlannerOptions, Context context, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics) {
        return EngineExecutor.create(this.engineContext, serviceContext, statement.getSessionConfig()).executeScalablePushQuery(analysis, statement, pushRouting, pushRoutingOptions, queryPlannerOptions, context, scalablePushQueryMetrics);
    }

    @Override
    public void updateStreamsPropertiesAndRestartRuntime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableAnalysis analyzeQueryWithNoOutputTopic(Query query, String queryText, Map<String, Object> configOverrides) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StreamPullQueryMetadata createStreamPullQuery(ServiceContext serviceContext, ImmutableAnalysis analysis, ConfiguredStatement<Query> statementOrig, boolean excludeTombstones) {
        throw new UnsupportedOperationException();
    }
}

