/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.generic;

import com.google.common.collect.Streams;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.engine.generic.GenericExpressionResolver;
import io.confluent.ksql.engine.generic.KsqlGenericRecord;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenericRecordFactory {
    private final KsqlConfig config;
    private final FunctionRegistry functionRegistry;
    private final LongSupplier clock;

    public GenericRecordFactory(KsqlConfig config, FunctionRegistry functionRegistry, LongSupplier clock) {
        this.config = Objects.requireNonNull(config, "config");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.clock = Objects.requireNonNull(clock, "clock");
    }

    public KsqlGenericRecord build(List<ColumnName> columnNames, List<Expression> expressions, LogicalSchema schema, DataSource.DataSourceType dataSourceType) {
        String noValue;
        List<ColumnName> columns;
        List<ColumnName> list = columns = columnNames.isEmpty() ? GenericRecordFactory.implicitColumns(schema) : columnNames;
        if (columns.size() != expressions.size()) {
            throw new KsqlException("Expected a value for each column. Expected Columns: " + String.valueOf(columnNames) + ". Got " + String.valueOf(expressions));
        }
        LogicalSchema schemaWithPseudoColumns = GenericRecordFactory.withPseudoColumns(schema);
        for (ColumnName col : columns) {
            if (!schemaWithPseudoColumns.findColumn(col).isPresent()) {
                throw new KsqlException("Column name " + String.valueOf(col) + " does not exist.");
            }
            if (!SystemColumns.isDisallowedForInsertValues((ColumnName)col)) continue;
            throw new KsqlException("Inserting into column " + String.valueOf(col) + " is not allowed.");
        }
        Map<ColumnName, Object> values = GenericRecordFactory.resolveValues(columns, expressions, schemaWithPseudoColumns, this.functionRegistry, this.config);
        if (dataSourceType == DataSource.DataSourceType.KTABLE && !(noValue = schemaWithPseudoColumns.key().stream().map(Column::name).filter(colName -> !values.containsKey(colName)).map(Name::text).collect(Collectors.joining(", "))).isEmpty()) {
            throw new KsqlException("Value for primary key column(s) " + noValue + " is required for tables");
        }
        long ts = (Long)values.getOrDefault(SystemColumns.ROWTIME_NAME, this.clock.getAsLong());
        GenericKey key = GenericRecordFactory.buildKey(schema, values);
        GenericRow value = GenericRecordFactory.buildValue(schema, values);
        return KsqlGenericRecord.of(key, value, ts);
    }

    private static List<ColumnName> implicitColumns(LogicalSchema schema) {
        return Streams.concat((Stream[])new Stream[]{schema.key().stream(), schema.value().stream()}).map(Column::name).collect(Collectors.toList());
    }

    private static LogicalSchema withPseudoColumns(LogicalSchema schema) {
        LogicalSchema.Builder builder = schema.asBuilder();
        builder.valueColumn(SystemColumns.ROWTIME_NAME, SystemColumns.ROWTIME_TYPE);
        builder.valueColumn(SystemColumns.ROWPARTITION_NAME, SystemColumns.ROWPARTITION_TYPE);
        builder.valueColumn(SystemColumns.ROWOFFSET_NAME, SystemColumns.ROWOFFSET_TYPE);
        return builder.build();
    }

    private static Map<ColumnName, Object> resolveValues(List<ColumnName> columns, List<Expression> expressions, LogicalSchema schema, FunctionRegistry functionRegistry, KsqlConfig config) {
        HashMap<ColumnName, Object> values = new HashMap<ColumnName, Object>();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnName column = columns.get(i);
            SqlType columnType = GenericRecordFactory.columnType(column, schema);
            Expression valueExp = expressions.get(i);
            Object value = new GenericExpressionResolver(columnType, column, functionRegistry, config, "insert value", false).resolve(valueExp);
            values.put(column, value);
        }
        return values;
    }

    private static SqlType columnType(ColumnName column, LogicalSchema schema) {
        return schema.findColumn(column).map(Column::type).orElseThrow(IllegalStateException::new);
    }

    private static GenericKey buildKey(LogicalSchema schema, Map<ColumnName, Object> values) {
        GenericKey.Builder builder = GenericKey.builder((LogicalSchema)schema);
        schema.key().stream().map(Column::name).map(values::get).forEach(arg_0 -> ((GenericKey.Builder)builder).append(arg_0));
        return builder.build();
    }

    private static GenericRow buildValue(LogicalSchema schema, Map<ColumnName, Object> values) {
        return new GenericRow().appendAll((Collection)schema.value().stream().map(Column::name).map(values::get).collect(Collectors.toList()));
    }
}

