/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution;

import io.confluent.ksql.execution.ExecutionPlan;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.planner.LogicalPlanNode;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import java.util.Optional;

public class ExecutionPlanBuilder {
    private final KsqlConfig ksqlConfig;
    private final ServiceContext serviceContext;
    private final ProcessingLogContext processingLogContext;
    private final FunctionRegistry functionRegistry;

    public ExecutionPlanBuilder(KsqlConfig ksqlConfig, ServiceContext serviceContext, ProcessingLogContext processingLogContext, FunctionRegistry functionRegistry) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
    }

    public ExecutionPlan buildPhysicalPlan(LogicalPlanNode logicalPlanNode, QueryId queryId, Optional<PlanInfo> oldPlanInfo) {
        LogicalSchema physicalSchema;
        OutputNode outputNode = logicalPlanNode.getNode().orElseThrow(() -> new IllegalArgumentException("Need an output node to build a plan"));
        PlanBuildContext buildContext = PlanBuildContext.of(this.ksqlConfig, this.serviceContext, this.functionRegistry, oldPlanInfo);
        SchemaKStream<?> resultStream = outputNode.buildStream(buildContext);
        LogicalSchema logicalSchema = outputNode.getSchema();
        if (!logicalSchema.equals((Object)(physicalSchema = resultStream.getSchema()))) {
            throw new IllegalStateException("Logical and Physical schemas do not match!" + System.lineSeparator() + "Logical : " + String.valueOf(logicalSchema) + System.lineSeparator() + "Physical: " + String.valueOf(physicalSchema));
        }
        return new ExecutionPlan(queryId, resultStream.getSourceStep());
    }
}

