/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.Window;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.PushOffsetRange;
import java.util.Objects;
import java.util.Optional;

public final class QueryRowImpl
implements QueryRow {
    private final LogicalSchema logicalSchema;
    private final long rowTime;
    private final GenericKey key;
    private final Optional<Window> window;
    private final GenericRow value;

    public static QueryRowImpl of(LogicalSchema logicalSchema, GenericKey key, Optional<Window> window, GenericRow value, long rowTime) {
        return new QueryRowImpl(logicalSchema, key, window, value, rowTime);
    }

    private QueryRowImpl(LogicalSchema logicalSchema, GenericKey key, Optional<Window> window, GenericRow value, long rowTime) {
        this.logicalSchema = logicalSchema;
        this.rowTime = rowTime;
        this.key = key;
        this.window = window;
        this.value = value;
    }

    @Override
    public LogicalSchema schema() {
        return this.logicalSchema;
    }

    @Override
    public long rowTime() {
        return this.rowTime;
    }

    @Override
    public GenericKey key() {
        return this.key;
    }

    @Override
    public Optional<Window> window() {
        return this.window;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public GenericRow value() {
        return this.value;
    }

    @Override
    public Optional<PushOffsetRange> getOffsetRange() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRowImpl that = (QueryRowImpl)o;
        return Objects.equals(this.logicalSchema, that.logicalSchema) && Objects.equals(this.key, that.key) && Objects.equals(this.window, that.window) && Objects.equals(this.value, that.value) && Objects.equals(this.rowTime, that.rowTime);
    }

    public int hashCode() {
        return Objects.hash(this.logicalSchema, this.key, this.window, this.value, this.rowTime);
    }

    public String toString() {
        return "QueryRowImpl{logicalSchema=" + String.valueOf(this.logicalSchema) + ", key=" + String.valueOf(this.key) + ", window=" + String.valueOf(this.window) + ", value=" + String.valueOf(this.value) + ", rowTime=" + this.rowTime + "}";
    }
}

