/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.pull.operators.DataSourceOperator;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.planner.plan.KeyConstraint;
import io.confluent.ksql.planner.plan.LookupConstraint;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PullPhysicalPlan {
    private static final Logger LOGGER = LogManager.getLogger(PullPhysicalPlan.class);
    private final AbstractPhysicalOperator root;
    private final LogicalSchema schema;
    private final QueryId queryId;
    private final List<LookupConstraint> lookupConstraints;
    private final PullPhysicalPlanType pullPhysicalPlanType;
    private final KsqlConstants.QuerySourceType querySourceType;
    private final Materialization mat;
    private final DataSourceOperator dataSourceOperator;

    public PullPhysicalPlan(AbstractPhysicalOperator root, LogicalSchema schema, QueryId queryId, List<LookupConstraint> lookupConstraints, PullPhysicalPlanType pullPhysicalPlanType, KsqlConstants.QuerySourceType querySourceType, Materialization mat, DataSourceOperator dataSourceOperator) {
        this.root = Objects.requireNonNull(root, "root");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.lookupConstraints = Objects.requireNonNull(lookupConstraints, "lookupConstraints");
        this.pullPhysicalPlanType = Objects.requireNonNull(pullPhysicalPlanType, "pullPhysicalPlanType");
        this.querySourceType = Objects.requireNonNull(querySourceType, "pullSourceType");
        this.mat = Objects.requireNonNull(mat, "mat");
        this.dataSourceOperator = Objects.requireNonNull(dataSourceOperator, "dataSourceOperator");
    }

    public void execute(List<Locator.KsqlPartitionLocation> locations, PullQueryWriteStream pullQueryQueue, Function<StreamedRow, StreamedRow> addDebugInfo) {
        this.dataSourceOperator.setPartitionLocations(locations);
        this.open();
        QueryRow row = (QueryRow)this.next();
        while (!pullQueryQueue.isDone() && row != null) {
            try {
                if (!pullQueryQueue.awaitCapacity(1L, TimeUnit.SECONDS)) {
                    continue;
                }
            }
            catch (InterruptedException e) {
                throw new KsqlException((Throwable)e);
            }
            StreamedRow streamedRow = addDebugInfo.apply(StreamedRow.pullRow((GenericRow)GenericRow.fromList((List)row.value().values()), Optional.empty()));
            pullQueryQueue.write((List<StreamedRow>)ImmutableList.of((Object)streamedRow));
            row = (QueryRow)this.next();
        }
        if (row != null) {
            LOGGER.info("Queue closed before results completed. Stopping execution.");
        }
        this.close();
    }

    private void open() {
        this.root.open();
    }

    private Object next() {
        return this.root.next();
    }

    private void close() {
        this.root.close();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AbstractPhysicalOperator getRoot() {
        return this.root;
    }

    public Materialization getMaterialization() {
        return this.mat;
    }

    public List<Locator.KsqlKey> getKeys() {
        ArrayList<Locator.KsqlKey> list = new ArrayList<Locator.KsqlKey>();
        for (LookupConstraint c : this.lookupConstraints) {
            if (c instanceof KeyConstraint) {
                KeyConstraint kc = (KeyConstraint)c;
                list.add(kc.getKsqlKey());
                continue;
            }
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(list);
    }

    public LogicalSchema getOutputSchema() {
        return this.schema;
    }

    public PullPhysicalPlanType getPlanType() {
        return this.pullPhysicalPlanType;
    }

    public KsqlConstants.QuerySourceType getSourceType() {
        return this.querySourceType;
    }

    public long getRowsReadFromDataSource() {
        return this.dataSourceOperator.getReturnedRowCount();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public static enum PullPhysicalPlanType {
        KEY_LOOKUP,
        RANGE_SCAN,
        TABLE_SCAN,
        UNKNOWN;

    }
}

