/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull;

import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.PullQueryValidator;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.ProjectOperator;
import io.confluent.ksql.execution.common.operators.SelectOperator;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.execution.pull.operators.DataSourceOperator;
import io.confluent.ksql.execution.pull.operators.KeyedTableLookupOperator;
import io.confluent.ksql.execution.pull.operators.KeyedWindowedTableLookupOperator;
import io.confluent.ksql.execution.pull.operators.LimitOperator;
import io.confluent.ksql.execution.pull.operators.TableScanOperator;
import io.confluent.ksql.execution.pull.operators.WindowedTableScanOperator;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.LogicalPlanNode;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.KeyConstraint;
import io.confluent.ksql.planner.plan.KsqlBareOutputNode;
import io.confluent.ksql.planner.plan.LookupConstraint;
import io.confluent.ksql.planner.plan.NonKeyConstraint;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.QueryFilterNode;
import io.confluent.ksql.planner.plan.QueryLimitNode;
import io.confluent.ksql.planner.plan.QueryProjectNode;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class PullPhysicalPlanBuilder {
    private final ProcessingLogContext processingLogContext;
    private final QueryContext.Stacker contextStacker;
    private final PersistentQueryMetadata persistentQueryMetadata;
    private final CompletableFuture<Void> shouldCancelOperations;
    private final QueryId queryId;
    private final Materialization mat;
    private final QueryPlannerOptions queryPlannerOptions;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;
    private List<LookupConstraint> lookupConstraints;
    private PullPhysicalPlan.PullPhysicalPlanType pullPhysicalPlanType;
    private KsqlConstants.QuerySourceType querySourceType;
    private boolean seenSelectOperator = false;

    public PullPhysicalPlanBuilder(ProcessingLogContext processingLogContext, PersistentQueryMetadata persistentQueryMetadata, ImmutableAnalysis analysis, QueryPlannerOptions queryPlannerOptions, CompletableFuture<Void> shouldCancelOperations, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.persistentQueryMetadata = Objects.requireNonNull(persistentQueryMetadata, "persistentQueryMetadata");
        this.shouldCancelOperations = Objects.requireNonNull(shouldCancelOperations, "shouldCancelOperations");
        this.consistencyOffsetVector = Objects.requireNonNull(consistencyOffsetVector, "consistencyOffsetVector");
        this.contextStacker = new QueryContext.Stacker();
        this.queryId = this.uniqueQueryId();
        this.mat = this.persistentQueryMetadata.getMaterialization(this.queryId, this.contextStacker).orElseThrow(() -> this.notMaterializedException(this.getSourceName(analysis)));
        this.queryPlannerOptions = queryPlannerOptions;
    }

    public PullPhysicalPlan buildPullPhysicalPlan(LogicalPlanNode logicalPlanNode) {
        DataSourceOperator dataSourceOperator = null;
        OutputNode outputNode = logicalPlanNode.getNode().orElseThrow(() -> new IllegalArgumentException("Need an output node to build a plan"));
        if (!(outputNode instanceof KsqlBareOutputNode)) {
            throw new KsqlException("Pull queries expect the root of the logical plan to be a KsqlBareOutputNode.");
        }
        PlanNode currentLogicalNode = outputNode.getSource();
        AbstractPhysicalOperator prevPhysicalOp = null;
        AbstractPhysicalOperator rootPhysicalOp = null;
        while (true) {
            AbstractPhysicalOperator currentPhysicalOp = null;
            if (currentLogicalNode instanceof QueryProjectNode) {
                currentPhysicalOp = this.translateProjectNode((QueryProjectNode)currentLogicalNode);
            } else if (currentLogicalNode instanceof QueryFilterNode) {
                currentPhysicalOp = this.translateFilterNode((QueryFilterNode)currentLogicalNode);
                this.seenSelectOperator = true;
            } else if (currentLogicalNode instanceof QueryLimitNode) {
                currentPhysicalOp = new LimitOperator((QueryLimitNode)currentLogicalNode);
            } else if (currentLogicalNode instanceof DataSourceNode) {
                currentPhysicalOp = this.translateDataSourceNode((DataSourceNode)currentLogicalNode);
                dataSourceOperator = (DataSourceOperator)((Object)currentPhysicalOp);
            } else {
                throw new KsqlException(String.format("Error in translating logical to physical plan for pull queries: unrecognized logical node %s.", currentLogicalNode));
            }
            if (prevPhysicalOp == null) {
                rootPhysicalOp = currentPhysicalOp;
            } else {
                prevPhysicalOp.addChild(currentPhysicalOp);
            }
            prevPhysicalOp = currentPhysicalOp;
            if (currentLogicalNode.getSources().isEmpty()) break;
            if (currentLogicalNode.getSources().size() > 1) {
                throw new KsqlException("Pull queries do not support joins or nested sub-queries yet.");
            }
            currentLogicalNode = currentLogicalNode.getSources().get(0);
        }
        if (dataSourceOperator == null) {
            throw new IllegalStateException("DataSourceOperator cannot be null in Pull physical plan");
        }
        return new PullPhysicalPlan(rootPhysicalOp, rootPhysicalOp.getLogicalNode().getSchema(), this.queryId, this.lookupConstraints, this.pullPhysicalPlanType, this.querySourceType, this.mat, dataSourceOperator);
    }

    private ProjectOperator translateProjectNode(QueryProjectNode logicalNode) {
        ProcessingLogger logger = this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName((QueryLoggerUtil.QueryType)QueryLoggerUtil.QueryType.PULL_QUERY, (QueryContext)this.contextStacker.push(new String[]{"PROJECT"}).getQueryContext()));
        return new ProjectOperator(logger, logicalNode);
    }

    private SelectOperator translateFilterNode(QueryFilterNode logicalNode) {
        this.lookupConstraints = logicalNode.getLookupConstraints();
        ProcessingLogger logger = this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName((QueryLoggerUtil.QueryType)QueryLoggerUtil.QueryType.PULL_QUERY, (QueryContext)this.contextStacker.push(new String[]{"SELECT"}).getQueryContext()));
        return new SelectOperator(logicalNode, logger);
    }

    private PullPhysicalPlan.PullPhysicalPlanType getPlanType() {
        if (!this.seenSelectOperator) {
            this.lookupConstraints = Collections.emptyList();
            return PullPhysicalPlan.PullPhysicalPlanType.TABLE_SCAN;
        }
        if (this.lookupConstraints.stream().anyMatch(lc -> lc instanceof NonKeyConstraint)) {
            this.lookupConstraints = Collections.emptyList();
            return PullPhysicalPlan.PullPhysicalPlanType.TABLE_SCAN;
        }
        if (this.lookupConstraints.stream().allMatch(lc -> ((KeyConstraint)lc).getOperator() == KeyConstraint.ConstraintOperator.EQUAL)) {
            return PullPhysicalPlan.PullPhysicalPlanType.KEY_LOOKUP;
        }
        if (this.lookupConstraints.size() == 1 && this.lookupConstraints.stream().allMatch(lc -> ((KeyConstraint)lc).getOperator() != KeyConstraint.ConstraintOperator.EQUAL)) {
            return PullPhysicalPlan.PullPhysicalPlanType.RANGE_SCAN;
        }
        this.lookupConstraints = Collections.emptyList();
        return PullPhysicalPlan.PullPhysicalPlanType.TABLE_SCAN;
    }

    private AbstractPhysicalOperator translateDataSourceNode(DataSourceNode logicalNode) {
        this.pullPhysicalPlanType = this.getPlanType();
        if (this.pullPhysicalPlanType == PullPhysicalPlan.PullPhysicalPlanType.RANGE_SCAN && (!this.queryPlannerOptions.getRangeScansEnabled() || logicalNode.isWindowed())) {
            this.pullPhysicalPlanType = PullPhysicalPlan.PullPhysicalPlanType.TABLE_SCAN;
        }
        if (this.pullPhysicalPlanType == PullPhysicalPlan.PullPhysicalPlanType.TABLE_SCAN) {
            if (this.queryPlannerOptions.getTableScansEnabled()) {
                this.lookupConstraints = Collections.emptyList();
            } else {
                throw new KsqlException("Query requires table scan to be enabled. Table scans can be enabled by setting ksql.query.pull.table.scan.enabled=true");
            }
        }
        KsqlConstants.QuerySourceType querySourceType = this.querySourceType = logicalNode.isWindowed() ? KsqlConstants.QuerySourceType.WINDOWED : KsqlConstants.QuerySourceType.NON_WINDOWED;
        if (this.pullPhysicalPlanType == PullPhysicalPlan.PullPhysicalPlanType.TABLE_SCAN) {
            if (!logicalNode.isWindowed()) {
                return new TableScanOperator(this.mat, logicalNode, this.shouldCancelOperations, this.consistencyOffsetVector);
            }
            return new WindowedTableScanOperator(this.mat, logicalNode, this.shouldCancelOperations, this.consistencyOffsetVector);
        }
        if (!logicalNode.isWindowed()) {
            return new KeyedTableLookupOperator(this.mat, logicalNode, this.consistencyOffsetVector);
        }
        return new KeyedWindowedTableLookupOperator(this.mat, logicalNode, this.consistencyOffsetVector);
    }

    private QueryId uniqueQueryId() {
        return new QueryId("query_" + System.currentTimeMillis());
    }

    private KsqlException notMaterializedException(SourceName sourceTable) {
        String tableName = sourceTable.text();
        return new KsqlException("The " + String.valueOf(sourceTable) + " table isn't queryable. To derive a queryable table, you can do 'CREATE TABLE QUERYABLE_" + tableName + " AS SELECT * FROM " + tableName + "'." + PullQueryValidator.PULL_QUERY_SYNTAX_HELP);
    }

    private SourceName getSourceName(ImmutableAnalysis analysis) {
        DataSource source = analysis.getFrom().getDataSource();
        return source.getName();
    }
}

