/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.execution.pull.PullQueryQueuePopulator;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConstants;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PullQueryResult {
    private static final Logger LOG = LogManager.getLogger(PullQueryResult.class);
    private final LogicalSchema schema;
    private final PullQueryQueuePopulator populator;
    private final QueryId queryId;
    private final PullQueryWriteStream pullQueryQueue;
    private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
    private final KsqlConstants.QuerySourceType sourceType;
    private final PullPhysicalPlan.PullPhysicalPlanType planType;
    private final KsqlConstants.RoutingNodeType routingNodeType;
    private final Supplier<Long> rowsProcessedSupplier;
    private final CompletableFuture<Void> shouldCancelRequests;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;
    private CompletableFuture<Void> future = new CompletableFuture();
    private boolean started = false;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "ParameterNumber"})
    public PullQueryResult(LogicalSchema schema, PullQueryQueuePopulator populator, QueryId queryId, PullQueryWriteStream pullQueryQueue, Optional<PullQueryExecutorMetrics> pullQueryMetrics, KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType, Supplier<Long> rowsProcessedSupplier, CompletableFuture<Void> shouldCancelRequests, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.schema = schema;
        this.populator = populator;
        this.queryId = queryId;
        this.pullQueryQueue = pullQueryQueue;
        this.pullQueryMetrics = pullQueryMetrics;
        this.sourceType = sourceType;
        this.planType = planType;
        this.routingNodeType = routingNodeType;
        this.rowsProcessedSupplier = rowsProcessedSupplier;
        this.shouldCancelRequests = shouldCancelRequests;
        this.consistencyOffsetVector = Objects.requireNonNull(consistencyOffsetVector, "consistencyOffsetVector");
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PullQueryWriteStream getPullQueryQueue() {
        return this.pullQueryQueue;
    }

    public Optional<ConsistencyOffsetVector> getConsistencyOffsetVector() {
        return this.consistencyOffsetVector;
    }

    public void start() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Should only start once");
        this.started = true;
        try {
            CompletableFuture<Void> f = this.populator.run();
            f.exceptionally(t -> {
                this.future.completeExceptionally((Throwable)t);
                return null;
            });
            f.thenAccept(this.future::complete);
        }
        catch (Throwable t2) {
            this.future.completeExceptionally(t2);
            throw t2;
        }
        this.onException(t -> this.pullQueryMetrics.ifPresent(metrics -> metrics.recordErrorRate(1.0, this.sourceType, this.planType, this.routingNodeType)));
    }

    public void stop() {
        try {
            this.pullQueryQueue.end();
        }
        catch (Throwable t) {
            LOG.error("Error closing pull query queue", t);
        }
        this.future.complete(null);
        this.shouldCancelRequests.complete(null);
    }

    public void onException(Consumer<Throwable> consumer) {
        this.future.exceptionally(t -> {
            consumer.accept((Throwable)t);
            return null;
        });
    }

    public void onCompletion(Consumer<Void> consumer) {
        this.future.thenAccept((Consumer)consumer);
    }

    public void onCompletionOrException(BiConsumer<Void, Throwable> biConsumer) {
        this.future.handle((v, t) -> {
            biConsumer.accept((Void)v, (Throwable)t);
            return null;
        });
    }

    public KsqlConstants.QuerySourceType getSourceType() {
        return this.sourceType;
    }

    public PullPhysicalPlan.PullPhysicalPlanType getPlanType() {
        return this.planType;
    }

    public KsqlConstants.RoutingNodeType getRoutingNodeType() {
        return this.routingNodeType;
    }

    public long getTotalRowsReturned() {
        return this.pullQueryQueue.getTotalRowsQueued();
    }

    public long getTotalRowsProcessed() {
        return this.rowsProcessedSupplier.get();
    }
}

