/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PullQueryRow {
    private final List<?> row;
    private final LogicalSchema schema;
    private final Optional<KsqlHostInfoEntity> sourceNode;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PullQueryRow(List<?> row, LogicalSchema schema, Optional<KsqlHostInfoEntity> sourceNode, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.row = row;
        this.schema = schema;
        this.sourceNode = sourceNode;
        this.consistencyOffsetVector = consistencyOffsetVector;
    }

    public List<?> getRow() {
        return Collections.unmodifiableList(this.row);
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public Optional<KsqlHostInfoEntity> getSourceNode() {
        return this.sourceNode;
    }

    public Optional<ConsistencyOffsetVector> getConsistencyOffsetVector() {
        return this.consistencyOffsetVector;
    }

    public GenericRow getGenericRow() {
        return PullQueryRow.toGenericRow(this.row);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PullQueryRow{");
        sb.append("row=").append(this.row);
        sb.append(", schema=").append(this.schema);
        sb.append(", sourceNode=").append(this.sourceNode);
        sb.append(", consistencyOffsetVector=").append(this.consistencyOffsetVector);
        sb.append('}');
        return sb.toString();
    }

    private static GenericRow toGenericRow(List<?> values) {
        return new GenericRow().appendAll(values);
    }
}

